/*
 * Decompiled with CFR 0.152.
 */
package de.spraener.nxtgen;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import de.spraener.nxtgen.CodeBlock;
import de.spraener.nxtgen.CodeGenerator;
import de.spraener.nxtgen.SimpleFileWriterCodeBlock;
import de.spraener.nxtgen.model.ModelElement;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class MustacheGenerator
implements CodeGenerator {
    private String mustacheResourcePath;
    private String outputFile;
    private BiConsumer<ModelElement, Map<String, Object>>[] buildScriptMapConsumer;

    public MustacheGenerator(String mustacheResourcePath, String outputFile, BiConsumer<ModelElement, Map<String, Object>> ... buildScriptMapConsumer) {
        this.mustacheResourcePath = mustacheResourcePath;
        this.outputFile = outputFile;
        this.buildScriptMapConsumer = buildScriptMapConsumer;
    }

    @Override
    public CodeBlock resolve(ModelElement modelElement, String templateName) {
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        try {
            Mustache mustache;
            try {
                mustache = mf.compile(this.mustacheResourcePath);
            }
            catch (Exception e) {
                mustache = mf.compile((Reader)new InputStreamReader(this.getClass().getResourceAsStream(this.mustacheResourcePath)), this.mustacheResourcePath);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(baos);
            HashMap scope = new HashMap();
            if (this.buildScriptMapConsumer != null) {
                for (BiConsumer<ModelElement, Map<String, Object>> consumer : this.buildScriptMapConsumer) {
                    consumer.accept(modelElement, scope);
                }
            }
            mustache.execute((Writer)pw, scope).flush();
            return new SimpleFileWriterCodeBlock(new String(baos.toByteArray()), this.outputFile);
        }
        catch (IOException ioXC) {
            throw new RuntimeException(ioXC);
        }
    }
}

