/*
 * Decompiled with CFR 0.152.
 */
package de.spraener.nxtgen.target;

import de.spraener.nxtgen.model.ModelElement;
import java.util.Stack;

public class CodeTargetContext
implements AutoCloseable {
    private static ThreadLocal<Stack<CodeTargetContext>> activeContext = new ThreadLocal();
    private static CodeTargetContext EMPTY_CONTEXT = new CodeTargetContext(null, null);
    private Object aspect;
    private ModelElement modelElement;

    public CodeTargetContext(Object aspect, ModelElement modelElement) {
        this.aspect = aspect;
        this.modelElement = modelElement;
        CodeTargetContext.getActiveContextStack().push(this);
    }

    public static CodeTargetContext getActiveContext() {
        if (activeContext.get() == null || activeContext.get().isEmpty()) {
            return EMPTY_CONTEXT;
        }
        return CodeTargetContext.getActiveContextStack().peek();
    }

    private static Stack<CodeTargetContext> getActiveContextStack() {
        Stack<CodeTargetContext> tlStack = activeContext.get();
        if (tlStack == null) {
            tlStack = new Stack();
            activeContext.set(tlStack);
        }
        return tlStack;
    }

    public Object getAspect() {
        return this.aspect;
    }

    public ModelElement getModelElement() {
        return this.modelElement;
    }

    @Override
    public void close() {
        CodeTargetContext.getActiveContextStack().pop();
        if (activeContext.get().isEmpty()) {
            activeContext.set(null);
        }
    }
}

