/*
 * Decompiled with CFR 0.152.
 */
package de.spraener.nxtgen.target;

import de.spraener.nxtgen.model.ModelElement;
import de.spraener.nxtgen.target.CodeSection;
import de.spraener.nxtgen.target.CodeTargetContext;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;

public class CodeTarget {
    private Map<Object, CodeSection> mySectionMap = new LinkedHashMap<Object, CodeSection>();

    public void addCodeSection(Object key, CodeSection aSection) {
        if (this.mySectionMap.get(key) != null) {
            throw new IllegalArgumentException("CodeSection with key " + key + " already added.");
        }
        this.mySectionMap.put(key, aSection);
    }

    public CodeTarget withCodeSection(Object key, CodeSection section) {
        this.addCodeSection(key, section);
        return this;
    }

    public CodeSection getSection(Object key) {
        return this.mySectionMap.get(key);
    }

    public Collection<CodeSection> getSectionsOrdered() {
        return this.mySectionMap.values();
    }

    public CodeTarget inContext(Object aspect, ModelElement me, Consumer<CodeTarget> ... consumers) {
        try (CodeTargetContext ctxt = new CodeTargetContext(aspect, me);){
            if (consumers != null) {
                for (Consumer<CodeTarget> consumer : consumers) {
                    consumer.accept(this);
                }
            }
        }
        return this;
    }
}

