/*
 * Decompiled with CFR 0.152.
 */
package de.spraener.nxtgen.model;

import de.spraener.nxtgen.model.Model;
import de.spraener.nxtgen.model.ModelElement;

public class ModelHelper {
    public static String getFQName(ModelElement me, String separator) {
        if (me.getParent() == null || me.getParent() instanceof Model) {
            return me.getName();
        }
        return ModelHelper.getFQName(me.getParent(), separator) + separator + me.getName();
    }

    public static ModelElement findByFQName(Model m, String fqName, String seperator) {
        for (ModelElement child : m.getModelElements()) {
            ModelElement target;
            if (child.getName().equals(fqName)) {
                return child;
            }
            if (!fqName.startsWith(child.getName()) || (target = ModelHelper.findByFQName(child, fqName.substring(child.getName().length() + seperator.length()), seperator)) == null) continue;
            return target;
        }
        return null;
    }

    public static ModelElement findByFQName(ModelElement parent, String fqName, String seperator) {
        if (fqName.equals(parent.getName())) {
            return parent;
        }
        if (fqName.contains(seperator)) {
            int idx = fqName.indexOf(seperator);
            String childName = fqName.substring(0, idx);
            String tail = fqName.substring(idx + seperator.length());
            ModelElement child = parent.getChilds().stream().filter(e -> e.getName().equals(childName)).findFirst().orElse(null);
            return ModelHelper.findByFQName(child, tail, seperator);
        }
        return parent.getChilds().stream().filter(c -> c.getName().equals(fqName)).findFirst().orElse(null);
    }
}

