/*
 * Decompiled with CFR 0.152.
 */
package de.spraener.nxtgen.incubator;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.MustacheFactory;
import de.spraener.nxtgen.incubator.BlueprintResourceLister;
import de.spraener.nxtgen.incubator.BlueprintSupplier;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BlueprintCompiler {
    private List<String> fileList = null;
    private BlueprintSupplier blueprintSupplier = null;
    private Map<String, String> scope = new HashMap<String, String>();
    MustacheFactory factory = new DefaultMustacheFactory();
    private String name;

    public BlueprintCompiler(String resourceRoot) {
        this.name = resourceRoot;
        BlueprintResourceLister bprl = new BlueprintResourceLister(resourceRoot);
        this.fileList = bprl.listFiles();
        this.blueprintSupplier = bprl;
        this.initScope();
    }

    public BlueprintCompiler(String name, List<String> fileList, BlueprintSupplier blueprintSupplier) {
        this.fileList = fileList;
        this.blueprintSupplier = blueprintSupplier;
        this.initScope();
    }

    public Map<String, String> getScope() {
        return this.scope;
    }

    private void initScope() {
        for (String resource : this.fileList) {
            for (String varName : this.listVarNames(resource)) {
                this.scope.put(varName, "undefined");
            }
        }
    }

    private Set<String> listVarNames(String resource) {
        HashSet<String> varList = new HashSet<String>();
        this.findMustaches(resource, varList);
        this.findMustaches(this.blueprintSupplier.getContent(resource), varList);
        return varList;
    }

    private Set<String> findMustaches(String template, Set<String> varSet) {
        int idx = 0;
        while ((idx = template.indexOf("{{", idx)) != -1) {
            int endIdx = template.indexOf("}}", idx + 2);
            String varName = template.substring(idx + 2, endIdx);
            varSet.add(varName);
            idx = endIdx + 2;
        }
        return varSet;
    }

    public void evaluateTo(String outDir) {
        for (String fromResource : this.fileList) {
            String toResource = outDir + "/" + this.toOutputFilePath(fromResource);
            String content = this.toOutputContent(fromResource);
            File outFile = new File(toResource);
            outFile.getParentFile().mkdirs();
            try (PrintWriter pw = new PrintWriter(toResource);){
                pw.println(content);
                pw.flush();
            }
            catch (IOException xc) {
                throw new RuntimeException(xc);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private String toOutputContent(String resource) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String toOutputFilePath(String filePathTemplate) {
        String outputFileName = filePathTemplate;
        for (String varName : this.listVarNames(filePathTemplate)) {
            outputFileName = outputFileName.replaceAll("\\{\\{" + varName + "\\}\\}", this.scope.get(varName));
        }
        if (outputFileName.endsWith(".mustache")) {
            outputFileName = outputFileName.substring(0, outputFileName.length() - 9);
        }
        return outputFileName;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getRequiredValues() {
        ArrayList<String> valueList = new ArrayList<String>();
        for (String key : this.scope.keySet()) {
            valueList.add(key);
        }
        Collections.sort(valueList);
        return valueList;
    }
}

