/*
 * Decompiled with CFR 0.152.
 */
package de.spraener.nxtgen.cartridges;

import de.spraener.nxtgen.Transformation;
import de.spraener.nxtgen.annotations.CGV19Transformation;
import de.spraener.nxtgen.model.ModelElement;
import de.spraener.nxtgen.model.Stereotype;
import java.lang.reflect.Method;

public class TransformationWrapper
implements Transformation {
    private CGV19Transformation transformationSpec;
    private Class<?> transformationClass;
    private Method txMethod = null;

    public TransformationWrapper(Class<?> t, Method txMethod) {
        this.transformationSpec = t.getAnnotation(CGV19Transformation.class);
        if (this.transformationSpec == null) {
            this.transformationSpec = txMethod.getAnnotation(CGV19Transformation.class);
        }
        try {
            t.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException nsmXC) {
            throw new IllegalArgumentException("Class " + t.getName() + " does not provide a default constructor.");
        }
        this.transformationClass = t;
        this.txMethod = txMethod;
    }

    public TransformationWrapper(Class<?> t) {
        this(t, TransformationWrapper.getTXMethod(t));
    }

    private static Method getTXMethod(Class<?> t) {
        try {
            return t.getMethod("doTransformation", ModelElement.class);
        }
        catch (ReflectiveOperationException roXC) {
            throw new IllegalArgumentException("Class " + t.getName() + " does not implement Transformation-Interface.");
        }
    }

    @Override
    public void doTransformation(ModelElement element) {
        if (this.transformationSpec.operatesOn().isAssignableFrom(element.getClass()) && this.hasStereotype(element, this.transformationSpec.requiredStereotype())) {
            try {
                Object txInstance = this.transformationClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.txMethod.invoke(txInstance, element);
            }
            catch (ReflectiveOperationException roXC) {
                throw new RuntimeException("Exception while calling transformation.", roXC);
            }
        }
    }

    private boolean hasStereotype(ModelElement element, String s) {
        for (Stereotype sType : element.getStereotypes()) {
            if (!sType.getName().equals(s)) continue;
            return true;
        }
        return false;
    }
}

