/*
 * Decompiled with CFR 0.152.
 */
package de.spraener.nxtgen;

import de.spraener.nxtgen.Cartridge;
import de.spraener.nxtgen.CodeBlock;
import de.spraener.nxtgen.CodeGeneratorMapping;
import de.spraener.nxtgen.ModelLoader;
import de.spraener.nxtgen.NxtGenRuntimeException;
import de.spraener.nxtgen.ProtectionStrategie;
import de.spraener.nxtgen.ProtectionStrategieDefaultImpl;
import de.spraener.nxtgen.Transformation;
import de.spraener.nxtgen.model.Model;
import de.spraener.nxtgen.model.ModelElement;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NextGen
implements Runnable {
    public static final Logger LOGGER = Logger.getLogger("NextGen");
    private static ProtectionStrategie protectionStrategie = null;
    private String modelURI;
    private static String workingDir;
    private static ThreadLocal<ModelLoader> activeLoader;
    private static Set<String> cartridgeNames;
    private static List<Cartridge> cartridgeList;
    private static List<ModelLoader> modelLoaderList;

    private NextGen(String modelURI) {
        this.modelURI = modelURI;
        if (workingDir == null) {
            workingDir = new File(".").getAbsolutePath();
        }
    }

    public static void setWorkingDir(String workingDir) {
        File f = new File(workingDir);
        if (!f.exists() || !f.isDirectory()) {
            throw new IllegalArgumentException("assigned working directory '" + workingDir + "' does not exists or is not a directory");
        }
        NextGen.workingDir = workingDir;
    }

    public static ProtectionStrategie getProtectionStrategie() {
        if (protectionStrategie == null) {
            ServiceLoader<ProtectionStrategie> protectionServices = ServiceLoader.load(ProtectionStrategie.class);
            if (!protectionServices.iterator().hasNext()) {
                LOGGER.fine("No ProtectionStrategie found. Using default.");
                protectionStrategie = new ProtectionStrategieDefaultImpl();
            } else {
                LOGGER.info("Using ProtectionStrategie '" + protectionStrategie.getClass().getName() + "'.");
                protectionStrategie = protectionServices.iterator().next();
            }
        }
        return protectionStrategie;
    }

    public static void runCartridgeWithName(String cartridgeName) {
        cartridgeNames.add(cartridgeName);
    }

    public static void addCartridge(Cartridge c) {
        cartridgeList.add(c);
    }

    public static void addModelLoader(ModelLoader ml) {
        modelLoaderList.add(ml);
    }

    private List<ModelLoader> locateModelLoader() {
        ArrayList<ModelLoader> result = new ArrayList<ModelLoader>();
        result.addAll(modelLoaderList);
        LOGGER.fine("Loading servcices for Interface " + ModelLoader.class.getName());
        ServiceLoader<ModelLoader> loaderServices = ServiceLoader.load(ModelLoader.class);
        if (!loaderServices.iterator().hasNext()) {
            LOGGER.info("No ModelLoader located. Generation finished.");
            return result;
        }
        loaderServices.forEach(loader -> {
            if (loader.canHandle(this.modelURI)) {
                result.add((ModelLoader)loader);
            }
        });
        return result;
    }

    private List<Cartridge> loadCartridges() {
        ArrayList<Cartridge> result = new ArrayList<Cartridge>();
        result.addAll(cartridgeList);
        ServiceLoader<Cartridge> loaderServices = ServiceLoader.load(Cartridge.class);
        loaderServices.forEach(result::add);
        StringBuilder sb = new StringBuilder();
        for (Cartridge c : result) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(c.getName());
        }
        LOGGER.info(() -> "found " + result.size() + " cartridges [" + sb + "].");
        return result;
    }

    @Override
    public void run() {
        try {
            String fqWorkingDir = new File(NextGen.getWorkingDir()).getAbsolutePath();
            LOGGER.info(() -> "starting codegen in working dir " + fqWorkingDir + " on model file " + this.modelURI);
            for (Cartridge c : this.loadCartridges()) {
                if (!cartridgeNames.isEmpty() && !cartridgeNames.contains(c.getName())) continue;
                List<Model> models = this.loadModels(this.modelURI);
                for (Model m : models) {
                    this.runTransformations(m, c);
                    for (CodeBlock cb : this.runCodeGenerators(c, m)) {
                        cb.writeOutput(NextGen.getWorkingDir());
                    }
                }
            }
        }
        catch (Exception e) {
            throw new NxtGenRuntimeException(e);
        }
    }

    public static String getWorkingDir() {
        return workingDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Model> loadModels(String modelURI) {
        ArrayList<Model> models = new ArrayList<Model>();
        for (ModelLoader loader : this.locateModelLoader()) {
            if (!loader.canHandle(modelURI)) continue;
            LOGGER.fine(() -> "loading model with loader " + loader.getClass().getName());
            try {
                NextGen.setActiveLoader(loader);
                Model m = loader.loadModel(modelURI);
                for (ModelElement e : m.getModelElements()) {
                    e.setModel(m);
                }
                models.add(m);
            }
            finally {
                NextGen.removeActiveLoader();
            }
        }
        if (models.isEmpty()) {
            LOGGER.warning(() -> "no loader could handel model " + modelURI + ". Terminating");
            throw new NxtGenRuntimeException("Unable to find a model loader for the given model uri: " + modelURI + ". Check your classpath");
        }
        return models;
    }

    private static void removeActiveLoader() {
        activeLoader.set(null);
    }

    public static void setActiveLoader(ModelLoader loader) {
        activeLoader.set(loader);
    }

    public static ModelLoader getActiveLoader() {
        return activeLoader.get();
    }

    private List<CodeBlock> runCodeGenerators(Cartridge cartridge, Model model) {
        ArrayList<CodeBlock> result = new ArrayList<CodeBlock>();
        List<CodeGeneratorMapping> mappings = cartridge.mapGenerators(model);
        if (mappings != null) {
            mappings.forEach(m -> result.add(m.getCodeGen().resolve(m.getGeneratorBaseELement(), "")));
        }
        return result;
    }

    private void runTransformations(Model model, Cartridge cartridge) {
        List<Transformation> transformations = cartridge.getTransformations();
        if (transformations != null) {
            transformations.forEach(t -> {
                LOGGER.fine(() -> "Running transformation " + t.getClass().getName());
                List<ModelElement> allElements = model.getModelElements();
                for (ModelElement e : allElements) {
                    t.doTransformation(e);
                }
            });
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            LOGGER.severe("usage: codegen <ModelURI>");
            return;
        }
        try {
            NextGen cg = new NextGen(args[0]);
            cg.run();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    static {
        activeLoader = new ThreadLocal();
        cartridgeNames = new HashSet<String>();
        cartridgeList = new ArrayList<Cartridge>();
        modelLoaderList = new ArrayList<ModelLoader>();
    }
}

