/*
 * Decompiled with CFR 0.152.
 */
package de.spraener.nxtgen;

import de.spraener.nxtgen.CodeBlock;
import de.spraener.nxtgen.NextGen;
import de.spraener.nxtgen.NxtGenRuntimeException;
import de.spraener.nxtgen.SimpleStringCodeBlock;
import de.spraener.nxtgen.filestrategies.ToFileStrategy;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class CodeBlockImpl
implements CodeBlock {
    List<CodeBlock> codeBlocks = new ArrayList<CodeBlock>();
    String name;
    private ToFileStrategy toFileStrategy = null;

    public CodeBlockImpl(String name) {
        this.name = name;
    }

    @Override
    public String toCode() {
        StringBuilder sb = new StringBuilder();
        for (CodeBlock cb : this.codeBlocks) {
            sb.append(cb.toCode());
        }
        return sb.toString();
    }

    @Override
    public void println(String txt) {
        this.addCodeBlock(new SimpleStringCodeBlock(txt));
    }

    @Override
    public void addCodeBlock(CodeBlock subBlock) {
        this.codeBlocks.add(subBlock);
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected boolean checkProtected(File outFile) {
        return NextGen.getProtectionStrategie().isProtected(outFile);
    }

    @Override
    public void writeOutput(String workingDir) {
        try {
            File outFile = this.getToFileStrategy().open();
            if (outFile.exists() && this.checkProtected(outFile)) {
                return;
            }
            outFile.getParentFile().mkdirs();
            PrintWriter pw = new PrintWriter(new FileWriter(outFile));
            pw.print(this.toCode());
            pw.flush();
            pw.close();
        }
        catch (IOException ioXc) {
            throw new NxtGenRuntimeException(ioXc);
        }
    }

    public ToFileStrategy getToFileStrategy() {
        return this.toFileStrategy;
    }

    @Override
    public void setToFileStrategy(ToFileStrategy toFileStrategy) {
        this.toFileStrategy = toFileStrategy;
    }
}

