/*
 * Decompiled with CFR 0.152.
 */
package de.spraener.nxtgen;

import de.spraener.nxtgen.NextGen;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class CGV19Config {
    private Properties props = null;
    private static CGV19Config myInstance = null;
    private Supplier<Reader> propertyReaderSupplier = this::getPropertyReader;
    private Supplier<Map<String, String>> envMapSupplier = System::getenv;

    public static CGV19Config getInstance(Consumer<CGV19Config> ... modifiers) {
        if (myInstance == null) {
            myInstance = new CGV19Config();
            if (modifiers != null) {
                for (Consumer<CGV19Config> m : modifiers) {
                    m.accept(myInstance);
                }
            }
        } else if (modifiers != null && modifiers.length > 0) {
            NextGen.LOGGER.warning("Calling CGV19Config.getInstance with modifiers to existent instance. Modifiers were not applied!");
        }
        return myInstance;
    }

    public CGV19Config withPropertyReaderSupplier(Supplier<Reader> propertyReaderSupplier) {
        this.propertyReaderSupplier = propertyReaderSupplier;
        return this;
    }

    public CGV19Config withEnvMapSupplier(Supplier<Map<String, String>> envMapSupplier) {
        this.envMapSupplier = envMapSupplier;
        return this;
    }

    private Reader getPropertyReader() {
        try {
            NextGen.LOGGER.info("Loading cgv19 properties form .cgv19.properties file into GCV19.definitions.");
            return new FileReader(".cgv19.properties");
        }
        catch (FileNotFoundException fnfXC) {
            return null;
        }
    }

    private Properties getProperties() {
        if (this.props != null) {
            return this.props;
        }
        this.props = new Properties();
        Reader propReader = this.propertyReaderSupplier.get();
        if (propReader != null) {
            try (Reader reader = propReader;){
                this.props.load(propReader);
            }
            catch (IOException xc) {
                NextGen.LOGGER.warning("PropertyFile .cgv19.properties could not be read. Error: " + xc.getMessage());
            }
        }
        NextGen.LOGGER.info("Adding environment variable with prefix 'cgv19_' or 'CGV19_' to CGV19Config.definitions removing prefix.");
        Map<String, String> envMap = this.envMapSupplier.get();
        for (Map.Entry<String, String> e : envMap.entrySet()) {
            String key = e.getKey().toString();
            if (!key.toLowerCase().startsWith("cgv19_")) continue;
            String value = envMap.get(key);
            this.props.setProperty(key.substring(6), value);
        }
        return this.props;
    }

    public static String definitionOf(String key) {
        return CGV19Config.getInstance(new Consumer[0]).getProperties().getProperty(key, key);
    }
}

