/*
 * Decompiled with CFR 0.152.
 */
package de.spqrinfo.vppserver.ippclient;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;

public class IppUtil {
    private static final String DEFAULT_CHARSET = "UTF-8";

    public static short toShort(byte a, byte b) {
        return (short)(((a & 0xFF) << 8) + (b & 0xFF));
    }

    public static String toHex(byte b) {
        String st = Integer.toHexString(b);
        return st.length() == 1 ? "0" + st : st;
    }

    public static String toHexWithMarker(byte b) {
        StringBuilder sb = new StringBuilder();
        sb.append("0x").append(IppUtil.toHex(b));
        return sb.toString();
    }

    static String toString(byte[] dst) {
        int l = dst.length;
        StringBuilder sb = new StringBuilder(l);
        for (int i = 0; i < l; ++i) {
            byte b = dst[i];
            int ival = b & 0xFF;
            char c = (char)ival;
            sb.append(c);
        }
        return sb.toString();
    }

    public static byte[] toBytes(String str, String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            encoding = DEFAULT_CHARSET;
        }
        return str.getBytes(encoding);
    }

    public static byte[] toBytes(String str) throws UnsupportedEncodingException {
        return IppUtil.toBytes(str, null);
    }

    static String toDateTime(byte[] dst) {
        StringBuffer sb = new StringBuffer();
        short year = IppUtil.toShort(dst[0], dst[1]);
        sb.append(year).append("-");
        byte month = dst[2];
        sb.append(month).append("-");
        byte day = dst[3];
        sb.append(day).append(",");
        byte hours = dst[4];
        sb.append(hours).append(":");
        byte min = dst[5];
        sb.append(min).append(":");
        byte sec = dst[6];
        sb.append(sec).append(".");
        byte decSec = dst[7];
        sb.append(decSec).append(",");
        byte b = dst[8];
        int ival = b & 0xFF;
        char c = (char)ival;
        sb.append(c);
        hours = dst[9];
        sb.append(hours).append(":");
        min = dst[10];
        sb.append(min);
        return sb.toString();
    }

    public static String toBoolean(byte b) {
        return b == 0 ? "false" : "true";
    }

    public static boolean isAlive(String ipAddress) throws IOException {
        return InetAddress.getByName(ipAddress).isReachable(2000);
    }

    public static String getTranslatedString(String str) throws CharacterCodingException {
        return IppUtil.getTranslatedString(str, null);
    }

    public static String getTranslatedString(String str, String charsetName) throws CharacterCodingException {
        if (charsetName == null) {
            charsetName = DEFAULT_CHARSET;
        }
        Charset charset = Charset.forName(charsetName);
        CharsetDecoder decoder = charset.newDecoder();
        CharsetEncoder encoder = charset.newEncoder();
        decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        ByteBuffer buf = encoder.encode(CharBuffer.wrap(str));
        CharBuffer cbuf = decoder.decode(buf);
        return cbuf.toString();
    }

    public static ByteBuffer concatenateBytebuffers(ArrayList<ByteBuffer> buffers) {
        ByteBuffer buf;
        int n = 0;
        for (ByteBuffer b : buffers) {
            n += b.remaining();
        }
        ByteBuffer byteBuffer = buf = n > 0 && buffers.get(0).isDirect() ? ByteBuffer.allocateDirect(n) : ByteBuffer.allocate(n);
        if (n > 0) {
            buf.order(buffers.get(0).order());
        }
        for (ByteBuffer b : buffers) {
            buf.put(b.duplicate());
        }
        buf.flip();
        return buf;
    }
}

