/*
 * Decompiled with CFR 0.152.
 */
package de.spqrinfo.vppserver.ippclient;

import de.spqrinfo.vppserver.ippclient.IppUtil;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IppTag {
    private static final byte MAJOR_VERSION = 1;
    private static final byte MINOR_VERSION = 1;
    private static final String ATTRIBUTES_CHARSET = "attributes-charset";
    private static final String ATTRIBUTES_NATURAL_LANGUAGE = "attributes-natural-language";
    private static final String ATTRIBUTES_CHARSET_VALUE = "utf-8";
    private static final String ATTRIBUTES_NATURAL_LANGUAGE_VALUE = "en-us";
    private static final short ATTRIBUTES_INTEGER_VALUE_LENGTH = 4;
    private static final short ATTRIBUTES_RANGE_OF_INT_VALUE_LENGTH = 8;
    private static final short ATTRIBUTES_BOOLEAN_VALUE_LENGTH = 1;
    private static final short ATTRIBUTES_RESOLUTION_VALUE_LENGTH = 9;
    private static final byte ATTRIBUTES_BOOLEAN_FALSE_VALUE = 0;
    private static final byte ATTRIBUTES_BOOLEAN_TRUE_VALUE = 1;
    private static final byte OPERATION_ATTRIBUTES_TAG = 1;
    private static final byte JOB_ATTRIBUTES_TAG = 2;
    private static final byte END_OF_ATTRIBUTES_TAG = 3;
    private static final byte PRINTER_ATTRIBUTES_TAG = 4;
    private static final byte UNSUPPORTED_ATTRIBUTES_TAG = 5;
    private static final byte SUBSCRIPTION_ATTRIBUTES_TAG = 6;
    private static final byte EVENT_NOTIFICATION_ATTRIBUTES_TAG = 7;
    private static final byte INTEGER_TAG = 33;
    private static final byte BOOLEAN_TAG = 34;
    private static final byte ENUM_TAG = 35;
    private static final byte RESOLUTION_TAG = 50;
    private static final byte RANGE_OF_INTEGER_TAG = 51;
    private static final byte TEXT_WITHOUT_LANGUAGE_TAG = 65;
    private static final byte NAME_WITHOUT_LANGUAGE_TAG = 66;
    private static final byte KEYWORD_TAG = 68;
    private static final byte URI_TAG = 69;
    private static final byte URI_SCHEME_TAG = 70;
    private static final byte CHARSET_TAG = 71;
    private static final byte NATURAL_LANGUAGE_TAG = 72;
    private static final byte MIME_MEDIA_TYPE_TAG = 73;
    private static final short NULL_LENGTH = 0;
    private static int requestID = 0;
    private static final Logger logger = LoggerFactory.getLogger(IppTag.class);

    public static ByteBuffer getOperation(ByteBuffer ippBuf, short operation) throws UnsupportedEncodingException {
        return IppTag.getOperation(ippBuf, operation, null, null);
    }

    public static ByteBuffer getOperation(ByteBuffer ippBuf, short operation, String charset, String naturalLanguage) throws UnsupportedEncodingException {
        if (ippBuf == null) {
            logger.error("IppTag.getOperation(): ippBuf is null");
            return null;
        }
        if (charset == null) {
            charset = ATTRIBUTES_CHARSET_VALUE;
        }
        if (naturalLanguage == null) {
            naturalLanguage = ATTRIBUTES_NATURAL_LANGUAGE_VALUE;
        }
        ippBuf.put((byte)1);
        ippBuf.put((byte)1);
        ippBuf.putShort(operation);
        ippBuf.putInt(++requestID);
        ippBuf.put((byte)1);
        ippBuf = IppTag.getCharset(ippBuf, ATTRIBUTES_CHARSET, charset);
        ippBuf = IppTag.getNaturalLanguage(ippBuf, ATTRIBUTES_NATURAL_LANGUAGE, naturalLanguage);
        return ippBuf;
    }

    public static ByteBuffer getOperationAttributesTag(ByteBuffer ippBuf) {
        if (ippBuf == null) {
            logger.error("IppTag.getOperationAttributesTag(): ippBuf is null");
            return null;
        }
        ippBuf.put((byte)1);
        return ippBuf;
    }

    public static ByteBuffer getJobAttributesTag(ByteBuffer ippBuf) {
        if (ippBuf == null) {
            logger.error("IppTag.getJobAttributesTag(): ippBuf is null");
            return null;
        }
        ippBuf.put((byte)2);
        return ippBuf;
    }

    public static ByteBuffer getSubscriptionAttributesTag(ByteBuffer ippBuf) {
        if (ippBuf == null) {
            logger.error("IppTag.getSubscriptionAttributesTag(): ippBuf is null");
            return null;
        }
        ippBuf.put((byte)6);
        return ippBuf;
    }

    public static ByteBuffer getEventNotificationAttributesTag(ByteBuffer ippBuf) {
        if (ippBuf == null) {
            logger.error("IppTag.getEventNotificationAttributesTag(): ippBuf is null");
            return null;
        }
        ippBuf.put((byte)7);
        return ippBuf;
    }

    public static ByteBuffer getUnsupportedAttributesTag(ByteBuffer ippBuf) {
        if (ippBuf == null) {
            logger.error("IppTag.getUnsupportedAttributesTag(): ippBuf is null");
            return null;
        }
        ippBuf.put((byte)5);
        return ippBuf;
    }

    public static ByteBuffer getPrinterAttributesTag(ByteBuffer ippBuf) {
        if (ippBuf == null) {
            logger.error("IppTag.getPrinterAttributesTag(): ippBuf is null");
            return null;
        }
        ippBuf.put((byte)4);
        return ippBuf;
    }

    public static ByteBuffer getCharset(ByteBuffer ippBuf) throws UnsupportedEncodingException {
        return IppTag.getCharset(ippBuf, null, null);
    }

    public static ByteBuffer getCharset(ByteBuffer ippBuf, String attributeName) throws UnsupportedEncodingException {
        return IppTag.getCharset(ippBuf, attributeName, null);
    }

    public static ByteBuffer getCharset(ByteBuffer ippBuf, String attributeName, String value) throws UnsupportedEncodingException {
        return IppTag.getUsAscii(ippBuf, (byte)71, attributeName, value);
    }

    public static ByteBuffer getNaturalLanguage(ByteBuffer ippBuf) throws UnsupportedEncodingException {
        return IppTag.getNaturalLanguage(ippBuf, null, null);
    }

    public static ByteBuffer getNaturalLanguage(ByteBuffer ippBuf, String attributeName) throws UnsupportedEncodingException {
        return IppTag.getNaturalLanguage(ippBuf, attributeName, null);
    }

    public static ByteBuffer getNaturalLanguage(ByteBuffer ippBuf, String attributeName, String value) throws UnsupportedEncodingException {
        return IppTag.getUsAscii(ippBuf, (byte)72, attributeName, value);
    }

    public static ByteBuffer getUri(ByteBuffer ippBuf) throws UnsupportedEncodingException {
        return IppTag.getUri(ippBuf, null, null);
    }

    public static ByteBuffer getUri(ByteBuffer ippBuf, String attributeName) throws UnsupportedEncodingException {
        return IppTag.getUri(ippBuf, attributeName, null);
    }

    public static ByteBuffer getUri(ByteBuffer ippBuf, String attributeName, String value) throws UnsupportedEncodingException {
        return IppTag.getUsAscii(ippBuf, (byte)69, attributeName, value);
    }

    public static ByteBuffer getUriScheme(ByteBuffer ippBuf) throws UnsupportedEncodingException {
        return IppTag.getUriScheme(ippBuf, null, null);
    }

    public static ByteBuffer getUriScheme(ByteBuffer ippBuf, String attributeName) throws UnsupportedEncodingException {
        return IppTag.getUriScheme(ippBuf, attributeName, null);
    }

    public static ByteBuffer getUriScheme(ByteBuffer ippBuf, String attributeName, String value) throws UnsupportedEncodingException {
        return IppTag.getUsAscii(ippBuf, (byte)70, attributeName, value);
    }

    public static ByteBuffer getNameWithoutLanguage(ByteBuffer ippBuf, String attributeName, String value) throws UnsupportedEncodingException {
        if (ippBuf == null) {
            logger.error("IppTag.getNameWithoutLanguage(): ippBuf is null");
            return null;
        }
        ippBuf.put((byte)66);
        if (attributeName != null) {
            IppTag.putAttName(ippBuf, attributeName);
        } else {
            ippBuf.putShort((short)0);
        }
        if (value != null) {
            IppTag.putAttName(ippBuf, value);
        } else {
            ippBuf.putShort((short)0);
        }
        return ippBuf;
    }

    public static ByteBuffer getTextWithoutLanguage(ByteBuffer ippBuf, String attributeName, String value) throws UnsupportedEncodingException {
        if (ippBuf == null) {
            logger.error("IppTag.getTextWithoutLanguage(): ippBuf is null");
            return null;
        }
        ippBuf.put((byte)65);
        if (attributeName != null) {
            IppTag.putAttName(ippBuf, attributeName);
        } else {
            ippBuf.putShort((short)0);
        }
        if (value != null) {
            IppTag.putAttName(ippBuf, value);
        } else {
            ippBuf.putShort((short)0);
        }
        return ippBuf;
    }

    public static ByteBuffer getInteger(ByteBuffer ippBuf) throws UnsupportedEncodingException {
        return IppTag.getInteger(ippBuf, null);
    }

    public static ByteBuffer getInteger(ByteBuffer ippBuf, String attributeName) throws UnsupportedEncodingException {
        if (ippBuf == null) {
            logger.error("IppTag.getInteger(): ippBuf is null");
            return null;
        }
        ippBuf.put((byte)33);
        if (attributeName != null) {
            IppTag.putAttName(ippBuf, attributeName);
        } else {
            ippBuf.putShort((short)0);
        }
        ippBuf.putShort((short)0);
        return ippBuf;
    }

    public static ByteBuffer getInteger(ByteBuffer ippBuf, String attributeName, int value) throws UnsupportedEncodingException {
        if (ippBuf == null) {
            logger.error("IppTag.getInteger(): ippBuf is null");
            return null;
        }
        ippBuf.put((byte)33);
        if (attributeName != null) {
            IppTag.putAttName(ippBuf, attributeName);
        } else {
            ippBuf.putShort((short)0);
        }
        ippBuf.putShort((short)4);
        ippBuf.putInt(value);
        return ippBuf;
    }

    public static ByteBuffer getBoolean(ByteBuffer ippBuf) throws UnsupportedEncodingException {
        return IppTag.getBoolean(ippBuf, null);
    }

    public static ByteBuffer getBoolean(ByteBuffer ippBuf, String attributeName) throws UnsupportedEncodingException {
        if (ippBuf == null) {
            logger.error("IppTag.getBoolean(): ippBuf is null");
            return null;
        }
        ippBuf.put((byte)34);
        if (attributeName != null) {
            IppTag.putAttName(ippBuf, attributeName);
        } else {
            ippBuf.putShort((short)0);
        }
        ippBuf.putShort((short)0);
        return ippBuf;
    }

    private static void putAttName(ByteBuffer ippBuf, String attributeName) throws UnsupportedEncodingException {
        byte[] bytes = IppUtil.toBytes(attributeName);
        ippBuf.putShort((short)bytes.length);
        ippBuf.put(bytes);
    }

    public static ByteBuffer getBoolean(ByteBuffer ippBuf, String attributeName, boolean value) throws UnsupportedEncodingException {
        if (ippBuf == null) {
            logger.error("IppTag.getBoolean(): ippBuf is null");
            return null;
        }
        ippBuf.put((byte)34);
        if (attributeName != null) {
            IppTag.putAttName(ippBuf, attributeName);
        } else {
            ippBuf.putShort((short)0);
        }
        ippBuf.putShort((short)1);
        if (value) {
            ippBuf.put((byte)1);
        } else {
            ippBuf.put((byte)0);
        }
        return ippBuf;
    }

    public static ByteBuffer getEnum(ByteBuffer ippBuf) throws UnsupportedEncodingException {
        return IppTag.getEnum(ippBuf, null);
    }

    public static ByteBuffer getEnum(ByteBuffer ippBuf, String attributeName) throws UnsupportedEncodingException {
        if (ippBuf == null) {
            logger.error("IppTag.getEnum(): ippBuf is null");
            return null;
        }
        ippBuf.put((byte)35);
        if (attributeName != null) {
            IppTag.putAttName(ippBuf, attributeName);
        } else {
            ippBuf.putShort((short)0);
        }
        ippBuf.putShort((short)0);
        return ippBuf;
    }

    public static ByteBuffer getEnum(ByteBuffer ippBuf, String attributeName, int value) throws UnsupportedEncodingException {
        if (ippBuf == null) {
            logger.error("IppTag.getEnum(): ippBuf is null");
            return null;
        }
        ippBuf.put((byte)35);
        if (attributeName != null) {
            IppTag.putAttName(ippBuf, attributeName);
        } else {
            ippBuf.putShort((short)0);
        }
        ippBuf.putShort((short)4);
        ippBuf.putInt(value);
        return ippBuf;
    }

    public static ByteBuffer getResolution(ByteBuffer ippBuf) throws UnsupportedEncodingException {
        return IppTag.getResolution(ippBuf, null);
    }

    public static ByteBuffer getResolution(ByteBuffer ippBuf, String attributeName) throws UnsupportedEncodingException {
        if (ippBuf == null) {
            logger.error("IppTag.getResolution(): ippBuf is null");
            return null;
        }
        ippBuf.put((byte)50);
        if (attributeName != null) {
            IppTag.putAttName(ippBuf, attributeName);
        } else {
            ippBuf.putShort((short)0);
        }
        ippBuf.putShort((short)0);
        return ippBuf;
    }

    public static ByteBuffer getResolution(ByteBuffer ippBuf, String attributeName, int value1, int value2, byte value3) throws UnsupportedEncodingException {
        if (ippBuf == null) {
            logger.error("IppTag.getResolution(): ippBuf is null");
            return null;
        }
        ippBuf.put((byte)50);
        if (attributeName != null) {
            IppTag.putAttName(ippBuf, attributeName);
        } else {
            ippBuf.putShort((short)0);
        }
        ippBuf.putShort((short)9);
        ippBuf.putInt(value1);
        ippBuf.putInt(value2);
        ippBuf.put(value3);
        return ippBuf;
    }

    public static ByteBuffer getRangeOfInteger(ByteBuffer ippBuf) throws UnsupportedEncodingException {
        return IppTag.getRangeOfInteger(ippBuf, null);
    }

    public static ByteBuffer getRangeOfInteger(ByteBuffer ippBuf, String attributeName) throws UnsupportedEncodingException {
        if (ippBuf == null) {
            logger.error("IppTag.getRangeOfInteger(): ippBuf is null");
            return null;
        }
        ippBuf.put((byte)51);
        if (attributeName != null) {
            IppTag.putAttName(ippBuf, attributeName);
        } else {
            ippBuf.putShort((short)0);
        }
        ippBuf.putShort((short)0);
        return ippBuf;
    }

    public static ByteBuffer getRangeOfInteger(ByteBuffer ippBuf, String attributeName, int value1, int value2) throws UnsupportedEncodingException {
        if (ippBuf == null) {
            logger.error("IppTag.getRangeOfInteger(): ippBuf is null");
            return null;
        }
        ippBuf.put((byte)51);
        if (attributeName != null) {
            IppTag.putAttName(ippBuf, attributeName);
        } else {
            ippBuf.putShort((short)0);
        }
        ippBuf.putShort((short)8);
        ippBuf.putInt(value1);
        ippBuf.putInt(value2);
        return ippBuf;
    }

    public static ByteBuffer getMimeMediaType(ByteBuffer ippBuf) throws UnsupportedEncodingException {
        return IppTag.getMimeMediaType(ippBuf, null, null);
    }

    public static ByteBuffer getMimeMediaType(ByteBuffer ippBuf, String attributeName) throws UnsupportedEncodingException {
        return IppTag.getMimeMediaType(ippBuf, attributeName, null);
    }

    public static ByteBuffer getMimeMediaType(ByteBuffer ippBuf, String attributeName, String value) throws UnsupportedEncodingException {
        return IppTag.getUsAscii(ippBuf, (byte)73, attributeName, value);
    }

    public static ByteBuffer getKeyword(ByteBuffer ippBuf) throws UnsupportedEncodingException {
        return IppTag.getKeyword(ippBuf, null, null);
    }

    public static ByteBuffer getKeyword(ByteBuffer ippBuf, String attributeName) throws UnsupportedEncodingException {
        return IppTag.getKeyword(ippBuf, attributeName, null);
    }

    public static ByteBuffer getKeyword(ByteBuffer ippBuf, String attributeName, String value) throws UnsupportedEncodingException {
        return IppTag.getUsAscii(ippBuf, (byte)68, attributeName, value);
    }

    public static ByteBuffer getEnd(ByteBuffer ippBuf) {
        if (ippBuf == null) {
            logger.error("IppTag.getEnd(): ippBuf is null");
            return null;
        }
        ippBuf.put((byte)3);
        return ippBuf;
    }

    private static ByteBuffer getUsAscii(ByteBuffer ippBuf, byte tag, String attributeName, String value) throws UnsupportedEncodingException {
        if (ippBuf == null) {
            logger.error("IppTag.getUsAscii(): ippBuf is null");
            return null;
        }
        ippBuf.put(tag);
        if (attributeName != null) {
            IppTag.putAttName(ippBuf, attributeName);
        } else {
            ippBuf.putShort((short)0);
        }
        if (value != null) {
            IppTag.putAttName(ippBuf, value);
        } else {
            ippBuf.putShort((short)0);
        }
        return ippBuf;
    }
}

