/*
 * Decompiled with CFR 0.152.
 */
package de.spqrinfo.vppserver.ippclient;

import de.spqrinfo.vppserver.ippclient.IppJaxb;
import de.spqrinfo.vppserver.ippclient.IppResult;
import de.spqrinfo.vppserver.ippclient.IppUtil;
import de.spqrinfo.vppserver.schema.ippclient.Attribute;
import de.spqrinfo.vppserver.schema.ippclient.AttributeGroup;
import de.spqrinfo.vppserver.schema.ippclient.AttributeValue;
import de.spqrinfo.vppserver.schema.ippclient.Enum;
import de.spqrinfo.vppserver.schema.ippclient.SetOfEnum;
import de.spqrinfo.vppserver.schema.ippclient.Tag;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IppResponse {
    private static final String CRLF = "\r\n";
    private List<Tag> _tagList = null;
    private List<AttributeGroup> _attributeGroupList = null;
    private static final int BYTEBUFFER_CAPACITY = 8192;
    private AttributeGroup _attributeGroupResult = null;
    private Attribute _attributeResult = null;
    private List<AttributeGroup> _result = null;
    private static IppJaxb ippJaxb = null;
    private static final Logger logger = LoggerFactory.getLogger(IppResponse.class);
    ByteBuffer _buf = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IppResponse() throws FileNotFoundException, JAXBException {
        if (ippJaxb == null) {
            IppResponse ippResponse = this;
            synchronized (ippResponse) {
                if (ippJaxb == null) {
                    ippJaxb = new IppJaxb();
                }
            }
        }
        this._tagList = ippJaxb.getTagList();
        this._attributeGroupList = ippJaxb.getAttributeGroupList();
        this._result = new ArrayList<AttributeGroup>();
        this._buf = ByteBuffer.allocate(8192);
    }

    public IppResult getResponse(SocketChannel channel) throws IOException {
        if (channel == null) {
            logger.error("IppResponse.getResponse(): no channel given");
            return null;
        }
        this._buf.clear();
        this._attributeGroupResult = null;
        this._attributeResult = null;
        this._result.clear();
        IppResult result = new IppResult();
        boolean httpResponse = false;
        boolean ippHeaderResponse = false;
        ByteBuffer tmpBuffer = ByteBuffer.allocate(8192);
        ArrayList<ByteBuffer> bufferList = new ArrayList<ByteBuffer>();
        while (channel.read(tmpBuffer) != -1) {
            tmpBuffer.flip();
            if (!httpResponse && tmpBuffer.hasRemaining()) {
                this._buf = tmpBuffer;
                result.setHttpStatusResponse(this.getHTTPHeader());
                httpResponse = true;
            }
            if (!ippHeaderResponse && tmpBuffer.hasRemaining()) {
                this._buf = tmpBuffer;
                result.setIppStatusResponse(this.getIPPHeader());
                ippHeaderResponse = true;
            }
            if (tmpBuffer.hasRemaining()) {
                bufferList.add(tmpBuffer);
            }
            tmpBuffer = ByteBuffer.allocate(8192);
        }
        this._buf = this.concatenateBytebuffers(bufferList);
        this.getAttributeGroupList();
        this.closeAttributeGroup();
        result.setAttributeGroupList(this._result);
        return result;
    }

    public IppResult getResponse(ByteBuffer buffer) throws IOException {
        this._buf.clear();
        this._attributeGroupResult = null;
        this._attributeResult = null;
        this._result.clear();
        IppResult result = new IppResult();
        boolean ippHeaderResponse = false;
        if (!ippHeaderResponse && buffer.hasRemaining()) {
            this._buf = buffer;
            result.setIppStatusResponse(this.getIPPHeader());
            ippHeaderResponse = true;
        }
        this._buf = buffer;
        this.getAttributeGroupList();
        this.closeAttributeGroup();
        result.setAttributeGroupList(this._result);
        return result;
    }

    private ByteBuffer concatenateBytebuffers(ArrayList<ByteBuffer> buffers) {
        ByteBuffer buf;
        int n = 0;
        for (ByteBuffer b : buffers) {
            n += b.remaining();
        }
        ByteBuffer byteBuffer = buf = n > 0 && buffers.get(0).isDirect() ? ByteBuffer.allocateDirect(n) : ByteBuffer.allocate(n);
        if (n > 0) {
            buf.order(buffers.get(0).order());
        }
        for (ByteBuffer b : buffers) {
            buf.put(b.duplicate());
        }
        buf.flip();
        return buf;
    }

    private String getHTTPHeader() {
        String endOf = "\r\n\r\n";
        StringBuffer sb = new StringBuffer();
        while (sb.indexOf(endOf) == -1) {
            byte b = this._buf.get();
            int ival = b & 0xFF;
            char c = (char)ival;
            sb.append(c);
        }
        if (sb.length() != 0) {
            return sb.toString();
        }
        return null;
    }

    private String getIPPHeader() {
        StringBuffer sb = new StringBuffer();
        sb.append("Major Version:" + IppUtil.toHexWithMarker(this._buf.get()));
        sb.append(" Minor Version:" + IppUtil.toHexWithMarker(this._buf.get()));
        String statusCode = IppUtil.toHexWithMarker(this._buf.get()) + IppUtil.toHex(this._buf.get());
        String statusMessage = this.getEnumName(statusCode, "status-code");
        sb.append(" Request Id:" + this._buf.getInt() + "\n");
        sb.append("Status Code:" + statusCode + "(" + statusMessage + ")");
        if (sb.length() != 0) {
            return sb.toString();
        }
        return null;
    }

    private List<AttributeGroup> getAttributeGroupList() {
        block28: while (this._buf.hasRemaining()) {
            byte tag = this._buf.get();
            switch (tag) {
                case 0: {
                    this.setAttributeGroup(tag);
                    continue block28;
                }
                case 1: {
                    this.setAttributeGroup(tag);
                    continue block28;
                }
                case 2: {
                    this.setAttributeGroup(tag);
                    continue block28;
                }
                case 3: {
                    return this._result;
                }
                case 4: {
                    this.setAttributeGroup(tag);
                    continue block28;
                }
                case 5: {
                    this.setAttributeGroup(tag);
                    continue block28;
                }
                case 6: {
                    this.setAttributeGroup(tag);
                    continue block28;
                }
                case 7: {
                    this.setAttributeGroup(tag);
                    continue block28;
                }
                case 19: {
                    this.setNoValueAttribute(tag);
                    continue block28;
                }
                case 33: {
                    this.setIntegerAttribute(tag);
                    continue block28;
                }
                case 34: {
                    this.setBooleanAttribute(tag);
                    continue block28;
                }
                case 35: {
                    this.setEnumAttribute(tag);
                    continue block28;
                }
                case 48: {
                    this.setTextAttribute(tag);
                    continue block28;
                }
                case 49: {
                    this.setDateTimeAttribute(tag);
                    continue block28;
                }
                case 50: {
                    this.setResolutionAttribute(tag);
                    continue block28;
                }
                case 51: {
                    this.setRangeOfIntegerAttribute(tag);
                    continue block28;
                }
                case 53: {
                    this.setTextWithLanguageAttribute(tag);
                    continue block28;
                }
                case 54: {
                    this.setNameWithLanguageAttribute(tag);
                    continue block28;
                }
                case 65: {
                    this.setTextAttribute(tag);
                    continue block28;
                }
                case 66: {
                    this.setTextAttribute(tag);
                    continue block28;
                }
                case 68: {
                    this.setTextAttribute(tag);
                    continue block28;
                }
                case 69: {
                    this.setTextAttribute(tag);
                    continue block28;
                }
                case 70: {
                    this.setTextAttribute(tag);
                    continue block28;
                }
                case 71: {
                    this.setTextAttribute(tag);
                    continue block28;
                }
                case 72: {
                    this.setTextAttribute(tag);
                    continue block28;
                }
                case 73: {
                    this.setTextAttribute(tag);
                    continue block28;
                }
            }
            return this._result;
        }
        return null;
    }

    private void setAttributeGroup(byte tag) {
        if (this._attributeGroupResult != null) {
            if (this._attributeResult != null) {
                this._attributeGroupResult.getAttribute().add(this._attributeResult);
            }
            this._result.add(this._attributeGroupResult);
        }
        this._attributeResult = null;
        this._attributeGroupResult = new AttributeGroup();
        this._attributeGroupResult.setTagName(this.getTagName(IppUtil.toHexWithMarker(tag)));
    }

    private void closeAttributeGroup() {
        if (this._attributeGroupResult != null) {
            if (this._attributeResult != null) {
                this._attributeGroupResult.getAttribute().add(this._attributeResult);
            }
            this._result.add(this._attributeGroupResult);
        }
        this._attributeResult = null;
        this._attributeGroupResult = null;
    }

    private void setTextAttribute(byte tag) {
        short length = this._buf.getShort();
        if (length != 0 && this._buf.remaining() >= length) {
            this.setAttributeName(length);
        }
        if (!this._buf.hasRemaining()) {
            return;
        }
        length = this._buf.getShort();
        if (length != 0 && this._buf.remaining() >= length) {
            byte[] dst = new byte[length];
            this._buf.get(dst);
            String value = IppUtil.toString(dst);
            String hex = IppUtil.toHexWithMarker(tag);
            AttributeValue attrValue = new AttributeValue();
            attrValue.setTag(hex);
            String tagName = this.getTagName(hex);
            attrValue.setTagName(tagName);
            attrValue.setValue(value);
            this._attributeResult.getAttributeValue().add(attrValue);
        }
    }

    private void setTextWithLanguageAttribute(byte tag) {
        short length = this._buf.getShort();
        if (length != 0 && this._buf.remaining() >= length) {
            this.setAttributeName(length);
        }
        if (!this._buf.hasRemaining()) {
            return;
        }
        length = this._buf.getShort();
        if (length != 0 && this._buf.remaining() >= length) {
            byte[] dst = new byte[length];
            this._buf.get(dst);
            String value = IppUtil.toString(dst);
            String hex = IppUtil.toHexWithMarker(tag);
            AttributeValue attrValue = new AttributeValue();
            attrValue.setTag(hex);
            String tagName = this.getTagName(hex);
            attrValue.setTagName(tagName);
            attrValue.setValue(value);
            this._attributeResult.getAttributeValue().add(attrValue);
            length = this._buf.getShort();
            if (length != 0 && this._buf.remaining() >= length) {
                dst = new byte[length];
                this._buf.get(dst);
                value = IppUtil.toString(dst);
                attrValue = new AttributeValue();
                attrValue.setValue(value);
                this._attributeResult.getAttributeValue().add(attrValue);
            }
        }
    }

    private void setNameWithLanguageAttribute(byte tag) {
        short length = this._buf.getShort();
        if (length != 0 && this._buf.remaining() >= length) {
            this.setAttributeName(length);
        }
        if (!this._buf.hasRemaining()) {
            return;
        }
        length = this._buf.getShort();
        if (length != 0 && this._buf.remaining() >= length) {
            byte[] dst = new byte[length];
            this._buf.get(dst);
            String value = IppUtil.toString(dst);
            String hex = IppUtil.toHexWithMarker(tag);
            AttributeValue attrValue = new AttributeValue();
            attrValue.setTag(hex);
            String tagName = this.getTagName(hex);
            attrValue.setTagName(tagName);
            attrValue.setValue(value);
            this._attributeResult.getAttributeValue().add(attrValue);
            length = this._buf.getShort();
            if (length != 0 && this._buf.remaining() >= length) {
                dst = new byte[length];
                this._buf.get(dst);
                value = IppUtil.toString(dst);
                attrValue = new AttributeValue();
                attrValue.setValue(value);
                this._attributeResult.getAttributeValue().add(attrValue);
            }
        }
    }

    private void setBooleanAttribute(byte tag) {
        short length = this._buf.getShort();
        if (length != 0 && this._buf.remaining() >= length) {
            this.setAttributeName(length);
        }
        if (!this._buf.hasRemaining()) {
            return;
        }
        length = this._buf.getShort();
        if (length != 0 && this._buf.remaining() >= length) {
            byte value = this._buf.get();
            String hex = IppUtil.toHexWithMarker(tag);
            AttributeValue attrValue = new AttributeValue();
            attrValue.setTag(hex);
            String tagName = this.getTagName(hex);
            attrValue.setTagName(tagName);
            attrValue.setValue(IppUtil.toBoolean(value));
            this._attributeResult.getAttributeValue().add(attrValue);
        }
    }

    private void setDateTimeAttribute(byte tag) {
        short length = this._buf.getShort();
        if (length != 0 && this._buf.remaining() >= length) {
            this.setAttributeName(length);
        }
        if (!this._buf.hasRemaining()) {
            return;
        }
        length = this._buf.getShort();
        if (length != 0 && this._buf.remaining() >= length) {
            byte[] dst = new byte[length];
            this._buf.get(dst, 0, length);
            String value = IppUtil.toDateTime(dst);
            String hex = IppUtil.toHexWithMarker(tag);
            AttributeValue attrValue = new AttributeValue();
            attrValue.setTag(hex);
            String tagName = this.getTagName(hex);
            attrValue.setTagName(tagName);
            attrValue.setValue(value);
            this._attributeResult.getAttributeValue().add(attrValue);
        }
    }

    private void setIntegerAttribute(byte tag) {
        short length = this._buf.getShort();
        if (length != 0 && this._buf.remaining() >= length) {
            this.setAttributeName(length);
        }
        if (!this._buf.hasRemaining()) {
            return;
        }
        length = this._buf.getShort();
        if (length != 0 && this._buf.remaining() >= length) {
            int value = this._buf.getInt();
            String hex = IppUtil.toHexWithMarker(tag);
            AttributeValue attrValue = new AttributeValue();
            attrValue.setTag(hex);
            String tagName = this.getTagName(hex);
            attrValue.setTagName(tagName);
            attrValue.setValue(Integer.toString(value));
            this._attributeResult.getAttributeValue().add(attrValue);
        }
    }

    private void setNoValueAttribute(byte tag) {
        short length = this._buf.getShort();
        if (length != 0 && this._buf.remaining() >= length) {
            this.setAttributeName(length);
        }
    }

    private void setRangeOfIntegerAttribute(byte tag) {
        short length = this._buf.getShort();
        if (length != 0 && this._buf.remaining() >= length) {
            this.setAttributeName(length);
        }
        if (!this._buf.hasRemaining()) {
            return;
        }
        length = this._buf.getShort();
        if (length != 0 && this._buf.remaining() >= length) {
            int value1 = this._buf.getInt();
            int value2 = this._buf.getInt();
            String hex = IppUtil.toHexWithMarker(tag);
            AttributeValue attrValue = new AttributeValue();
            attrValue.setTag(hex);
            String tagName = this.getTagName(hex);
            attrValue.setTagName(tagName);
            attrValue.setValue(Integer.toString(value1) + "," + Integer.toString(value2));
            this._attributeResult.getAttributeValue().add(attrValue);
        }
    }

    private void setResolutionAttribute(byte tag) {
        short length = this._buf.getShort();
        if (length != 0 && this._buf.remaining() >= length) {
            this.setAttributeName(length);
        }
        if (!this._buf.hasRemaining()) {
            return;
        }
        length = this._buf.getShort();
        if (length != 0 && this._buf.remaining() >= length) {
            int value1 = this._buf.getInt();
            int value2 = this._buf.getInt();
            byte value3 = this._buf.get();
            String hex = IppUtil.toHexWithMarker(tag);
            AttributeValue attrValue = new AttributeValue();
            attrValue.setTag(hex);
            String tagName = this.getTagName(hex);
            attrValue.setTagName(tagName);
            attrValue.setValue(Integer.toString(value1) + "," + Integer.toString(value2) + "," + Integer.toString(value3));
            this._attributeResult.getAttributeValue().add(attrValue);
        }
    }

    private void setEnumAttribute(byte tag) {
        short length = this._buf.getShort();
        if (length != 0 && this._buf.remaining() >= length) {
            this.setAttributeName(length);
        }
        if (!this._buf.hasRemaining()) {
            return;
        }
        length = this._buf.getShort();
        if (length != 0 && this._buf.remaining() >= length) {
            String hex = IppUtil.toHexWithMarker(tag);
            AttributeValue attrValue = new AttributeValue();
            attrValue.setTag(hex);
            String tagName = this.getTagName(hex);
            attrValue.setTagName(tagName);
            int value = this._buf.getInt();
            if (this._attributeResult != null) {
                String enumName = this.getEnumName(value, this._attributeResult.getName());
                attrValue.setValue(enumName);
            } else {
                this._attributeResult = new Attribute();
                this._attributeResult.setName("no attribute name given:");
                attrValue.setValue(Integer.toString(value));
            }
            this._attributeResult.getAttributeValue().add(attrValue);
        }
    }

    private void setAttributeName(short length) {
        if (length == 0 || this._buf.remaining() < length) {
            return;
        }
        byte[] dst = new byte[length];
        this._buf.get(dst);
        String name = IppUtil.toString(dst);
        if (this._attributeResult != null) {
            this._attributeGroupResult.getAttribute().add(this._attributeResult);
        }
        this._attributeResult = new Attribute();
        this._attributeResult.setName(name.toString());
    }

    private String getTagName(String tag) {
        if (tag == null) {
            logger.error("IppResponse.getTagName(): no tag given");
            return null;
        }
        int l = this._tagList.size();
        for (int i = 0; i < l; ++i) {
            if (!tag.equals(this._tagList.get(i).getValue())) continue;
            return this._tagList.get(i).getName();
        }
        return "no name found for tag:" + tag;
    }

    private String getEnumName(String value, String nameOfAttribute) {
        if (value == null) {
            logger.error("IppResponse.getEnumName(String,String): value is null");
            return null;
        }
        if (nameOfAttribute == null) {
            logger.error("IppResponse.getEnumName(String,String): nameOfAttribute is null");
            return null;
        }
        int enumValue = 0;
        if (value.contains("0x")) {
            value = value.replace("0x", "");
            enumValue = Integer.parseInt(value, 16);
        } else {
            enumValue = Integer.parseInt(value, 10);
        }
        return this.getEnumName(enumValue, nameOfAttribute);
    }

    private String getEnumName(int value, String nameOfAttribute) {
        if (nameOfAttribute == null) {
            logger.error("IppResponse.getEnumName(int,String): nameOfAttribute is null");
            return null;
        }
        int l = this._attributeGroupList.size();
        for (int i = 0; i < l; ++i) {
            AttributeGroup attributeGroup = this._attributeGroupList.get(i);
            List<Attribute> attributeList = attributeGroup.getAttribute();
            int ll = attributeList.size();
            for (int j = 0; j < ll; ++j) {
                Attribute attribute = attributeList.get(j);
                String attributeName = attribute.getName();
                if (attributeName == null || !attributeName.equals(nameOfAttribute)) continue;
                List<AttributeValue> attributeValueList = attribute.getAttributeValue();
                int lll = attributeValueList.size();
                for (int z = 0; z < lll; ++z) {
                    AttributeValue attributeValue = attributeValueList.get(z);
                    if (attributeValue.getSetOfEnum() != null) {
                        SetOfEnum setOfEnum = attributeValue.getSetOfEnum();
                        List<Enum> enumList = setOfEnum.getEnum();
                        int llll = enumList.size();
                        for (int w = 0; w < llll; ++w) {
                            Enum enumEntry = enumList.get(w);
                            String enumValueString = enumEntry.getValue();
                            int enumValue = 0;
                            if (enumValueString.contains("0x")) {
                                enumValueString = enumValueString.replace("0x", "");
                                enumValue = Integer.parseInt(enumValueString, 16);
                            } else {
                                enumValue = Integer.parseInt(enumValueString, 10);
                            }
                            if (value != enumValue) continue;
                            return enumEntry.getName();
                        }
                        continue;
                    }
                    logger.error("IPPResponse.getEnumName(): set-of-enum is null for attribute " + attributeName + ". Please control the enumeration list in the XML file");
                    return null;
                }
            }
        }
        return "enum name not found in IANA list: " + value;
    }
}

