/*
 * Decompiled with CFR 0.152.
 */
package de.spqrinfo.vppserver.ippclient;

import de.spqrinfo.vppserver.schema.ippclient.AttributeGroup;
import de.spqrinfo.vppserver.schema.ippclient.AttributeList;
import de.spqrinfo.vppserver.schema.ippclient.Tag;
import de.spqrinfo.vppserver.schema.ippclient.TagList;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IppJaxb {
    private static final Logger logger = LoggerFactory.getLogger(IppJaxb.class);
    private static final String TAG_LIST_FILENAME = "ipp-list-of-tag.xml";
    private static final String ATTRIBUTE_LIST_FILENAME = "ipp-list-of-attributes.xml";
    private static final String CONTEXT = "de.spqrinfo.vppserver.schema.ippclient";
    private List<Tag> tagList = null;
    private List<AttributeGroup> attributeGroupList = null;

    IppJaxb() throws FileNotFoundException, JAXBException {
        Throwable throwable;
        try {
            throwable = null;
            try (InputStream tagListStream = this.getClass().getResourceAsStream(TAG_LIST_FILENAME);){
                if (tagListStream == null) {
                    throw new FileNotFoundException("Cannot load ipp-list-of-tag.xml from classpath (null)");
                }
                TagList tagList = (TagList)this.unmarshal(tagListStream, CONTEXT);
                this.tagList = tagList.getTag();
            }
            catch (Throwable tagList) {
                throwable = tagList;
                throw tagList;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load ipp-list-of-tag.xml from classpath", e);
        }
        try {
            throwable = null;
            try (InputStream attListStream = this.getClass().getResourceAsStream(ATTRIBUTE_LIST_FILENAME);){
                if (attListStream == null) {
                    throw new FileNotFoundException("Cannot load ipp-list-of-attributes.xml from classpath (null)");
                }
                AttributeList attributeList = (AttributeList)this.unmarshal(attListStream, CONTEXT);
                this.attributeGroupList = attributeList.getAttributeGroup();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            throw new FileNotFoundException("Cannot load ipp-list-of-attributes.xml from classpath (null)");
        }
    }

    private Object unmarshal(InputStream inputStream, String context) throws JAXBException, FileNotFoundException {
        Objects.requireNonNull(inputStream, "InputStream cannot be null");
        Objects.requireNonNull(context, "Context cannot be null");
        logger.debug("Attempt to unmarshal from stream {} and context {}", (Object)inputStream, (Object)context);
        JAXBContext jc = JAXBContext.newInstance((String)context);
        Unmarshaller u = jc.createUnmarshaller();
        return u.unmarshal(inputStream);
    }

    List<Tag> getTagList() {
        return this.tagList;
    }

    List<AttributeGroup> getAttributeGroupList() {
        return this.attributeGroupList;
    }
}

