/*
 * Decompiled with CFR 0.152.
 */
package de.spinscale.elasticsearch.service.suggest;

import de.spinscale.elasticsearch.service.suggest.ShardSuggestService;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.HighFrequencyDictionary;
import org.apache.lucene.search.suggest.analyzing.AnalyzingSuggester;
import org.apache.lucene.search.suggest.analyzing.FuzzySuggester;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.cache.CacheLoader;
import org.elasticsearch.common.cache.LoadingCache;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;

public abstract class AbstractCacheLoaderSuggester<T>
extends CacheLoader<ShardSuggestService.FieldType, T> {
    private MapperService mapperService;
    private AnalysisService analysisService;
    protected LoadingCache<String, HighFrequencyDictionary> dictCache;

    public AbstractCacheLoaderSuggester(MapperService mapperService, AnalysisService analysisService, LoadingCache<String, HighFrequencyDictionary> dictCache) {
        this.mapperService = mapperService;
        this.analysisService = analysisService;
        this.dictCache = dictCache;
    }

    public T load(ShardSuggestService.FieldType fieldType) throws Exception {
        MapperService.SmartNameFieldMappers fieldMappers = this.mapperService.smartName(fieldType.field(), fieldType.types());
        StandardAnalyzer queryAnalyzer = null;
        StandardAnalyzer indexAnalyzer = null;
        if (fieldMappers != null) {
            NamedAnalyzer namedAnalyzer;
            FieldMapper fieldMapper = this.mapperService.smartName(fieldType.field(), fieldType.types()).mapper();
            queryAnalyzer = fieldMapper.searchAnalyzer();
            if (Strings.hasLength((String)fieldType.indexAnalyzer())) {
                namedAnalyzer = this.analysisService.analyzer(fieldType.queryAnalyzer());
                if (namedAnalyzer == null) {
                    throw new ElasticsearchException("Query analyzer[" + fieldType.queryAnalyzer() + "] does not exist.");
                }
                queryAnalyzer = namedAnalyzer.analyzer();
            }
            indexAnalyzer = fieldMapper.searchAnalyzer();
            if (Strings.hasLength((String)fieldType.indexAnalyzer())) {
                namedAnalyzer = this.analysisService.analyzer(fieldType.indexAnalyzer());
                if (namedAnalyzer == null) {
                    throw new ElasticsearchException("Index analyzer[" + fieldType.indexAnalyzer() + "] does not exist.");
                }
                indexAnalyzer = namedAnalyzer.analyzer();
            }
        }
        if (queryAnalyzer == null) {
            queryAnalyzer = new StandardAnalyzer(Version.CURRENT.luceneVersion);
        }
        if (indexAnalyzer == null) {
            indexAnalyzer = new StandardAnalyzer(Version.CURRENT.luceneVersion);
        }
        return this.getSuggester((Analyzer)indexAnalyzer, (Analyzer)queryAnalyzer, fieldType);
    }

    public abstract T getSuggester(Analyzer var1, Analyzer var2, ShardSuggestService.FieldType var3) throws Exception;

    public static class CacheLoaderFuzzySuggester
    extends AbstractCacheLoaderSuggester<FuzzySuggester> {
        public CacheLoaderFuzzySuggester(MapperService mapperService, AnalysisService analysisService, LoadingCache<String, HighFrequencyDictionary> dictCache) {
            super(mapperService, analysisService, dictCache);
        }

        @Override
        public FuzzySuggester getSuggester(Analyzer indexAnalyzer, Analyzer queryAnalyzer, ShardSuggestService.FieldType fieldType) throws Exception {
            FuzzySuggester fuzzySuggester = new FuzzySuggester(indexAnalyzer, queryAnalyzer, 3, 256, -1, fieldType.preservePositionIncrements(), 1, true, 1, 3, false);
            fuzzySuggester.build((Dictionary)this.dictCache.getUnchecked((Object)fieldType.field()));
            return fuzzySuggester;
        }
    }

    public static class CacheLoaderAnalyzingSuggester
    extends AbstractCacheLoaderSuggester<AnalyzingSuggester> {
        public CacheLoaderAnalyzingSuggester(MapperService mapperService, AnalysisService analysisService, LoadingCache<String, HighFrequencyDictionary> dictCache) {
            super(mapperService, analysisService, dictCache);
        }

        @Override
        public AnalyzingSuggester getSuggester(Analyzer indexAnalyzer, Analyzer queryAnalyzer, ShardSuggestService.FieldType fieldType) throws Exception {
            AnalyzingSuggester analyzingSuggester = new AnalyzingSuggester(indexAnalyzer, queryAnalyzer, 1, 256, -1, fieldType.preservePositionIncrements());
            analyzingSuggester.build((Dictionary)this.dictCache.getUnchecked((Object)fieldType.field()));
            return analyzingSuggester;
        }
    }
}

