/*
 * Decompiled with CFR 0.152.
 */
package de.spinscale.elasticsearch.plugin.suggest;

import de.spinscale.elasticsearch.action.suggest.refresh.SuggestRefreshAction;
import de.spinscale.elasticsearch.action.suggest.refresh.TransportSuggestRefreshAction;
import de.spinscale.elasticsearch.action.suggest.statistics.SuggestStatisticsAction;
import de.spinscale.elasticsearch.action.suggest.statistics.TransportSuggestStatisticsAction;
import de.spinscale.elasticsearch.action.suggest.suggest.SuggestAction;
import de.spinscale.elasticsearch.action.suggest.suggest.TransportSuggestAction;
import de.spinscale.elasticsearch.module.suggest.ShardSuggestModule;
import de.spinscale.elasticsearch.rest.action.suggest.RestRefreshSuggestAction;
import de.spinscale.elasticsearch.rest.action.suggest.RestStatisticsAction;
import de.spinscale.elasticsearch.rest.action.suggest.RestSuggestAction;
import de.spinscale.elasticsearch.service.suggest.SuggestService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionModule;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugins.AbstractPlugin;
import org.elasticsearch.rest.RestModule;

public class SuggestPlugin
extends AbstractPlugin {
    private final boolean isClient;

    @Inject
    public SuggestPlugin(Settings settings) {
        this.isClient = settings.getAsBoolean("node.client", Boolean.valueOf(false));
        try {
            if (Version.CURRENT.before(Version.V_1_2_4)) {
                throw new Exception();
            }
        }
        catch (Throwable e) {
            String error = String.format(Locale.ROOT, "The elasticsearch suggest plugin needs a newer version of elasticsearch than %s", Version.CURRENT);
            throw new ElasticsearchException(error);
        }
    }

    public String name() {
        return "suggest";
    }

    public String description() {
        return "Suggest Plugin";
    }

    public void onModule(RestModule restModule) {
        restModule.addRestAction(RestSuggestAction.class);
        restModule.addRestAction(RestRefreshSuggestAction.class);
        restModule.addRestAction(RestStatisticsAction.class);
    }

    public void onModule(ActionModule actionModule) {
        actionModule.registerAction((GenericAction)SuggestAction.INSTANCE, TransportSuggestAction.class, new Class[0]);
        actionModule.registerAction((GenericAction)SuggestRefreshAction.INSTANCE, TransportSuggestRefreshAction.class, new Class[0]);
        actionModule.registerAction((GenericAction)SuggestStatisticsAction.INSTANCE, TransportSuggestStatisticsAction.class, new Class[0]);
    }

    public Collection<Class<? extends LifecycleComponent>> services() {
        ArrayList services = Lists.newArrayList();
        if (!this.isClient) {
            services.add(SuggestService.class);
        }
        return services;
    }

    public Collection<Class<? extends Module>> shardModules() {
        ArrayList modules = Lists.newArrayList();
        modules.add(ShardSuggestModule.class);
        return modules;
    }
}

