/*
 * Decompiled with CFR 0.152.
 */
package de.spinscale.elasticsearch.action.suggest.suggest;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastOperationResponse;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.action.support.RestActions;

public class SuggestResponse
extends BroadcastOperationResponse
implements ToXContent {
    private List<String> suggestions;

    public SuggestResponse() {
    }

    public SuggestResponse(List<String> suggestions, int totalShards, int successfulShards, int failedShards, List<ShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.suggestions = suggestions;
    }

    public List<String> suggestions() {
        return Lists.newArrayList(this.suggestions);
    }

    public List<String> getSuggestions() {
        return Lists.newArrayList(this.suggestions);
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.suggestions = (List)in.readGenericValue();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeGenericValue(this.suggestions);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        RestActions.buildBroadcastShardsHeader((XContentBuilder)builder, (BroadcastOperationResponse)this);
        builder.field("suggestions", this.suggestions);
        return builder;
    }
}

