/*
 * Decompiled with CFR 0.152.
 */
package de.spinscale.elasticsearch.plugin.suggest;

import de.spinscale.elasticsearch.module.suggest.ShardSuggestModule;
import de.spinscale.elasticsearch.module.suggest.SuggestClientModule;
import de.spinscale.elasticsearch.module.suggest.SuggestModule;
import de.spinscale.elasticsearch.rest.action.suggest.RestRefreshSuggestAction;
import de.spinscale.elasticsearch.rest.action.suggest.RestStatisticsAction;
import de.spinscale.elasticsearch.rest.action.suggest.RestSuggestAction;
import de.spinscale.elasticsearch.service.suggest.SuggestService;
import java.util.ArrayList;
import java.util.Collection;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.Version;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugins.AbstractPlugin;
import org.elasticsearch.rest.RestModule;

public class SuggestPlugin
extends AbstractPlugin {
    private final Settings settings;

    @Inject
    public SuggestPlugin(Settings settings) {
        this.settings = settings;
        try {
            if (Version.CURRENT.before(Version.V_0_90_3)) {
                throw new Exception();
            }
        }
        catch (Throwable e) {
            String error = String.format("The elasticsearch suggest plugin needs a newer version of elasticsearch than %s", Version.CURRENT);
            throw new ElasticSearchException(error);
        }
    }

    public String name() {
        return "suggest";
    }

    public String description() {
        return "Suggest Plugin";
    }

    public void onModule(RestModule restModule) {
        restModule.addRestAction(RestSuggestAction.class);
        restModule.addRestAction(RestRefreshSuggestAction.class);
        restModule.addRestAction(RestStatisticsAction.class);
    }

    public Collection<Class<? extends LifecycleComponent>> services() {
        ArrayList services = Lists.newArrayList();
        if (!this.isClient()) {
            services.add(SuggestService.class);
        }
        return services;
    }

    public Collection<Class<? extends Module>> modules() {
        ArrayList modules = Lists.newArrayList();
        if (this.isClient()) {
            modules.add(SuggestClientModule.class);
        } else {
            modules.add(SuggestModule.class);
        }
        return modules;
    }

    public Collection<Class<? extends Module>> shardModules() {
        ArrayList modules = Lists.newArrayList();
        modules.add(ShardSuggestModule.class);
        return modules;
    }

    private boolean isClient() {
        return this.settings.getAsBoolean("node.client", Boolean.valueOf(false));
    }
}

