/*
 * Decompiled with CFR 0.152.
 */
package de.spinscale.elasticsearch.action.suggest.suggest;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.broadcast.BroadcastOperationRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class SuggestRequest
extends BroadcastOperationRequest {
    private String[] types = Strings.EMPTY_ARRAY;
    private int size = 10;
    private String field;
    private float similarity = 1.0f;
    private String term;
    private String suggestType = "fst";
    private String queryAnalyzer;
    private String indexAnalyzer;
    private boolean preservePositionIncrements = true;

    public SuggestRequest() {
    }

    public SuggestRequest(String ... indices) {
        super(indices);
    }

    public int size() {
        return this.size;
    }

    public void size(int size) {
        this.size = size;
    }

    public String field() {
        return this.field;
    }

    public void field(String field) {
        this.field = field;
    }

    public float similarity() {
        return this.similarity;
    }

    public void similarity(float similarity) {
        this.similarity = similarity;
    }

    public String term() {
        return this.term;
    }

    public void term(String term) {
        this.term = term;
    }

    public void suggestType(String suggestType) {
        this.suggestType = suggestType;
    }

    public String suggestType() {
        return this.suggestType;
    }

    public String queryAnalyzer() {
        return this.queryAnalyzer;
    }

    public void queryAnalyzer(String queryAnalyzer) {
        this.queryAnalyzer = queryAnalyzer;
    }

    public String indexAnalyzer() {
        return this.indexAnalyzer;
    }

    public void indexAnalyzer(String indexAnalyzer) {
        this.indexAnalyzer = indexAnalyzer;
    }

    public void analyzer(String analyzer) {
        this.indexAnalyzer(analyzer);
        this.queryAnalyzer(analyzer);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.field == null || this.field.length() == 0) {
            validationException = ValidateActions.addValidationError((String)"No suggest field specified", (ActionRequestValidationException)validationException);
        }
        if (this.term == null || this.term.length() == 0) {
            validationException = ValidateActions.addValidationError((String)"No query term specified", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    String[] types() {
        return this.types;
    }

    public SuggestRequest types(String ... types) {
        this.types = types;
        return this;
    }

    public SuggestRequest preservePositionIncrements(boolean preservePositionIncrements) {
        this.preservePositionIncrements = preservePositionIncrements;
        return this;
    }

    public boolean preservePositionIncrements() {
        return this.preservePositionIncrements;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.size = in.readVInt();
        this.similarity = in.readFloat();
        this.field = in.readString();
        this.term = in.readString();
        this.suggestType = in.readString();
        this.queryAnalyzer = in.readOptionalString();
        this.indexAnalyzer = in.readOptionalString();
        this.types = in.readStringArray();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.size);
        out.writeFloat(this.similarity);
        out.writeString(this.field);
        out.writeString(this.term);
        out.writeString(this.suggestType);
        out.writeOptionalString(this.queryAnalyzer);
        out.writeOptionalString(this.indexAnalyzer);
        out.writeStringArray(this.types);
    }

    public String toString() {
        return String.format("[%s] %s, field[%s], term[%s], size[%s], similarity[%s], suggestType[%s], indexAnalyzer[%s], queryAnalyzer[%s]", Arrays.toString(this.indices), Arrays.toString(this.types), this.field, this.term, this.size, Float.valueOf(this.similarity), this.suggestType, this.indexAnalyzer, this.queryAnalyzer);
    }
}

