/*
 * Decompiled with CFR 0.152.
 */
package de.spinscale.elasticsearch.action.suggest.suggest;

import de.spinscale.elasticsearch.action.suggest.suggest.SuggestRequest;
import java.io.IOException;
import org.elasticsearch.action.support.broadcast.BroadcastOperationRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ShardSuggestRequest
extends BroadcastShardOperationRequest {
    private int size = 10;
    private String field;
    private float similarity = 1.0f;
    private String term;
    private String[] types = Strings.EMPTY_ARRAY;
    private String suggestType = "fst";
    private String queryAnalyzer;
    private String indexAnalyzer;
    private boolean preservePositionIncrements = true;

    public ShardSuggestRequest() {
    }

    public ShardSuggestRequest(String index, int shardId, SuggestRequest request) {
        super(index, shardId, (BroadcastOperationRequest)request);
        this.size = request.size();
        this.field = request.field();
        this.term = request.term();
        this.similarity = request.similarity();
        this.types = request.types();
        this.suggestType = request.suggestType();
        this.queryAnalyzer = request.queryAnalyzer();
        this.indexAnalyzer = request.indexAnalyzer();
        this.preservePositionIncrements = request.preservePositionIncrements();
    }

    public int size() {
        return this.size;
    }

    public void size(int size) {
        this.size = size;
    }

    public String field() {
        return this.field;
    }

    public void field(String field) {
        this.field = field;
    }

    public float similarity() {
        return this.similarity;
    }

    public void similarity(float similarity) {
        this.similarity = similarity;
    }

    public String term() {
        return this.term;
    }

    public void term(String term) {
        this.term = term;
    }

    public String suggestType() {
        return this.suggestType;
    }

    public void suggestType(String suggestType) {
        this.suggestType = suggestType;
    }

    public String[] types() {
        return this.types;
    }

    public String queryAnalyzer() {
        return this.queryAnalyzer;
    }

    public void queryAnalyzer(String queryAnalyzer) {
        this.queryAnalyzer = queryAnalyzer;
    }

    public String indexAnalyzer() {
        return this.indexAnalyzer;
    }

    public void indexAnalyzer(String indexAnalyzer) {
        this.indexAnalyzer = indexAnalyzer;
    }

    public boolean preservePositionIncrements() {
        return this.preservePositionIncrements;
    }

    public void preservePositionIncrements(boolean preservePositionIncrements) {
        this.preservePositionIncrements = preservePositionIncrements;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.size = in.readVInt();
        this.similarity = in.readFloat();
        this.field = in.readString();
        this.term = in.readString();
        this.suggestType = in.readString();
        this.queryAnalyzer = in.readOptionalString();
        this.indexAnalyzer = in.readOptionalString();
        this.types = in.readStringArray();
        this.preservePositionIncrements = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.size);
        out.writeFloat(this.similarity);
        out.writeString(this.field);
        out.writeString(this.term);
        out.writeString(this.suggestType);
        out.writeOptionalString(this.queryAnalyzer);
        out.writeOptionalString(this.indexAnalyzer);
        out.writeStringArrayNullable(this.types);
        out.writeBoolean(this.preservePositionIncrements);
    }
}

