/*
 * Decompiled with CFR 0.152.
 */
package de.spinscale.elasticsearch.rest.action.suggest;

import de.spinscale.elasticsearch.action.suggest.suggest.SuggestAction;
import de.spinscale.elasticsearch.action.suggest.suggest.SuggestRequest;
import de.spinscale.elasticsearch.action.suggest.suggest.SuggestResponse;
import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.broadcast.BroadcastOperationResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestSuggestAction
extends BaseRestHandler {
    @Inject
    public RestSuggestAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/__suggest", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/__suggest", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/__suggest", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/__suggest", (RestHandler)this);
    }

    public void handleRequest(final RestRequest request, final RestChannel channel) {
        String[] indices = Strings.splitStringByCommaToArray((String)request.param("index"));
        try {
            Map parserMap = null;
            if (request.hasContent()) {
                XContentParser parser = XContentFactory.xContent((BytesReference)request.content()).createParser(request.content());
                parserMap = parser.mapAndClose();
            } else if (request.hasParam("source")) {
                String source = request.param("source");
                XContentParser parser = XContentFactory.xContent((CharSequence)source).createParser(source);
                parserMap = parser.mapAndClose();
            } else {
                this.handleException(channel, request, (Throwable)new ElasticSearchException("Please provide body data or source parameter"));
            }
            SuggestRequest suggestRequest = new SuggestRequest(indices);
            suggestRequest.field(XContentMapValues.nodeStringValue(parserMap.get("field"), (String)""));
            suggestRequest.suggestType(XContentMapValues.nodeStringValue(parserMap.get("type"), (String)""));
            if (parserMap.containsKey("analyzer")) {
                suggestRequest.indexAnalyzer(XContentMapValues.nodeStringValue(parserMap.get("analyzer"), (String)""));
                suggestRequest.queryAnalyzer(XContentMapValues.nodeStringValue(parserMap.get("analyzer"), (String)""));
            } else {
                suggestRequest.indexAnalyzer(XContentMapValues.nodeStringValue(parserMap.get("indexAnalyzer"), (String)""));
                suggestRequest.queryAnalyzer(XContentMapValues.nodeStringValue(parserMap.get("queryAnalyzer"), (String)""));
            }
            suggestRequest.term(XContentMapValues.nodeStringValue(parserMap.get("term"), (String)""));
            suggestRequest.similarity(XContentMapValues.nodeFloatValue(parserMap.get("similarity"), (float)1.0f));
            suggestRequest.size(XContentMapValues.nodeIntegerValue(parserMap.get("size"), (int)10));
            this.client.execute((Action)SuggestAction.INSTANCE, (ActionRequest)suggestRequest, (ActionListener)new ActionListener<SuggestResponse>(){

                public void onResponse(SuggestResponse response) {
                    try {
                        XContentBuilder builder = RestXContentBuilder.restContentBuilder((RestRequest)request);
                        builder.startObject();
                        RestActions.buildBroadcastShardsHeader((XContentBuilder)builder, (BroadcastOperationResponse)response);
                        builder.field("suggestions", response.suggestions());
                        builder.endObject();
                        channel.sendResponse((RestResponse)new XContentRestResponse(request, RestStatus.OK, builder));
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                public void onFailure(Throwable e) {
                    RestSuggestAction.this.handleException(channel, request, e);
                }
            });
        }
        catch (IOException e) {
            this.handleException(channel, request, e);
        }
    }

    final void handleException(RestChannel channel, RestRequest request, Throwable e) {
        try {
            channel.sendResponse((RestResponse)new XContentThrowableRestResponse(request, e));
        }
        catch (IOException e1) {
            this.logger.error("Failed to send failure response", (Throwable)e1, new Object[0]);
        }
    }
}

