/*
 * Decompiled with CFR 0.152.
 */
package de.spinscale.elasticsearch.rest.action.suggest;

import de.spinscale.elasticsearch.action.suggest.refresh.SuggestRefreshAction;
import de.spinscale.elasticsearch.action.suggest.refresh.SuggestRefreshRequest;
import de.spinscale.elasticsearch.action.suggest.refresh.SuggestRefreshResponse;
import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.StringRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;

public class RestRefreshSuggestAction
extends BaseRestHandler {
    @Inject
    public RestRefreshSuggestAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.POST, "/__suggestRefresh", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/__suggestRefresh", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/__suggestRefresh", (RestHandler)this);
    }

    public void handleRequest(final RestRequest request, final RestChannel channel) {
        String[] indices = Strings.splitStringByCommaToArray((String)request.param("index"));
        try {
            XContentParser parser;
            Map parserMap;
            SuggestRefreshRequest suggestRefreshRequest = new SuggestRefreshRequest(indices);
            if (request.hasContent() && (parserMap = (parser = XContentFactory.xContent((BytesReference)request.content()).createParser(request.content())).mapAndClose()).containsKey("field")) {
                suggestRefreshRequest.field(XContentMapValues.nodeStringValue(parserMap.get("field"), (String)""));
            }
            this.client.execute((Action)SuggestRefreshAction.INSTANCE, (ActionRequest)suggestRefreshRequest, (ActionListener)new ActionListener<SuggestRefreshResponse>(){

                public void onResponse(SuggestRefreshResponse response) {
                    try {
                        channel.sendResponse((RestResponse)new StringRestResponse(RestStatus.OK));
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse((RestResponse)new XContentThrowableRestResponse(request, e));
                    }
                    catch (IOException e1) {
                        RestRefreshSuggestAction.this.logger.error("Failed to send failure response", (Throwable)e1, new Object[0]);
                    }
                }
            });
        }
        catch (IOException e) {
            try {
                channel.sendResponse((RestResponse)new XContentThrowableRestResponse(request, (Throwable)e));
            }
            catch (IOException e1) {
                this.logger.error("Failed to send failure response", (Throwable)e1, new Object[0]);
            }
        }
    }
}

