/*
 * Decompiled with CFR 0.152.
 */
package de.spinscale.elasticsearch.action.suggest.statistics;

import de.spinscale.elasticsearch.action.suggest.statistics.ShardSuggestStatisticsRequest;
import de.spinscale.elasticsearch.action.suggest.statistics.ShardSuggestStatisticsResponse;
import de.spinscale.elasticsearch.action.suggest.statistics.SuggestStatisticsRequest;
import de.spinscale.elasticsearch.action.suggest.statistics.SuggestStatisticsResponse;
import de.spinscale.elasticsearch.service.suggest.ShardSuggestService;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.TransportBroadcastOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.IndexShardException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportSuggestStatisticsAction
extends TransportBroadcastOperationAction<SuggestStatisticsRequest, SuggestStatisticsResponse, ShardSuggestStatisticsRequest, ShardSuggestStatisticsResponse> {
    private final IndicesService indicesService;

    @Inject
    public TransportSuggestStatisticsAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService) {
        super(settings, threadPool, clusterService, transportService);
        this.indicesService = indicesService;
    }

    protected String transportAction() {
        return "suggestStatistics";
    }

    protected String executor() {
        return "management";
    }

    protected SuggestStatisticsRequest newRequest() {
        return new SuggestStatisticsRequest();
    }

    protected SuggestStatisticsResponse newResponse(SuggestStatisticsRequest request, AtomicReferenceArray shardsResponses, ClusterState clusterState) {
        int successfulShards = 0;
        int failedShards = 0;
        ArrayList shardFailures = Lists.newArrayList();
        ArrayList successfulStatistics = Lists.newArrayList();
        for (int i = 0; i < shardsResponses.length(); ++i) {
            Object shardResponse = shardsResponses.get(i);
            if (shardResponse == null) {
                ++failedShards;
                continue;
            }
            if (shardResponse instanceof BroadcastShardOperationFailedException) {
                ++failedShards;
                shardFailures.add(new DefaultShardOperationFailedException((IndexShardException)((BroadcastShardOperationFailedException)shardResponse)));
                continue;
            }
            ++successfulShards;
            successfulStatistics.add((ShardSuggestStatisticsResponse)((Object)shardResponse));
        }
        return new SuggestStatisticsResponse(shardsResponses.length(), successfulShards, failedShards, successfulStatistics, shardFailures);
    }

    protected ShardSuggestStatisticsRequest newShardRequest() {
        return new ShardSuggestStatisticsRequest();
    }

    protected ShardSuggestStatisticsRequest newShardRequest(ShardRouting shard, SuggestStatisticsRequest request) {
        return new ShardSuggestStatisticsRequest(shard.index(), shard.id(), request);
    }

    protected ShardSuggestStatisticsResponse newShardResponse() {
        return new ShardSuggestStatisticsResponse();
    }

    protected ShardSuggestStatisticsResponse shardOperation(ShardSuggestStatisticsRequest request) throws ElasticSearchException {
        IndexService indexService = this.indicesService.indexServiceSafe(request.index());
        ShardSuggestService suggestShardService = (ShardSuggestService)((Object)indexService.shardInjectorSafe(request.shardId()).getInstance(ShardSuggestService.class));
        return suggestShardService.getStatistics();
    }

    protected GroupShardsIterator shards(ClusterState clusterState, SuggestStatisticsRequest request, String[] concreteIndices) {
        return this.clusterService.operationRouting().searchShards(clusterState, request.indices(), concreteIndices, null, null);
    }

    protected ClusterBlockException checkGlobalBlock(ClusterState state, SuggestStatisticsRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA);
    }

    protected ClusterBlockException checkRequestBlock(ClusterState state, SuggestStatisticsRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA, concreteIndices);
    }
}

