/*
 * Decompiled with CFR 0.152.
 */
package de.spinscale.elasticsearch.action.suggest.statistics;

import de.spinscale.elasticsearch.action.suggest.statistics.FstStats;
import de.spinscale.elasticsearch.action.suggest.statistics.ShardSuggestStatisticsResponse;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastOperationResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class SuggestStatisticsResponse
extends BroadcastOperationResponse {
    private FstStats fstStats = new FstStats();

    public SuggestStatisticsResponse() {
    }

    public SuggestStatisticsResponse(int totalShards, int successfulShards, int failedShards, List<ShardSuggestStatisticsResponse> successfulStatistics, List<ShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        for (ShardSuggestStatisticsResponse response : successfulStatistics) {
            if (response.getFstIndexShardStats() == null || response.getFstIndexShardStats().size() <= 0) continue;
            this.fstStats.getStats().addAll(response.getFstIndexShardStats());
        }
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.fstStats = new FstStats();
        this.fstStats.readFrom(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.fstStats.writeTo(out);
    }

    public FstStats fstStats() {
        return this.fstStats;
    }

    public FstStats getFstStats() {
        return this.fstStats;
    }
}

