/*
 * Decompiled with CFR 0.152.
 */
package de.spinscale.elasticsearch.action.suggest.statistics;

import de.spinscale.elasticsearch.action.suggest.statistics.FstStats;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationResponse;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public class ShardSuggestStatisticsResponse
extends BroadcastShardOperationResponse {
    private List<FstStats.FstIndexShardStats> shardStats = Lists.newArrayList();

    public ShardSuggestStatisticsResponse() {
    }

    public ShardSuggestStatisticsResponse(ShardId shardId) {
        super(shardId.getIndex(), shardId.id());
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        long size = in.readLong();
        if (size > 0L) {
            int i = 0;
            while ((long)i < size) {
                FstStats.FstIndexShardStats fstIndexShardStats = new FstStats.FstIndexShardStats();
                fstIndexShardStats.readFrom(in);
                this.shardStats.add(fstIndexShardStats);
                ++i;
            }
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong((long)this.shardStats.size());
        for (FstStats.FstIndexShardStats fstIndexShardStats : this.shardStats) {
            fstIndexShardStats.writeTo(out);
        }
    }

    public List<FstStats.FstIndexShardStats> getFstIndexShardStats() {
        return this.shardStats;
    }
}

