/*
 * Decompiled with CFR 0.152.
 */
package de.spinscale.elasticsearch.action.suggest.statistics;

import de.spinscale.elasticsearch.service.suggest.ShardSuggestService;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.shard.ShardId;

public class FstStats
implements Streamable,
Serializable,
ToXContent {
    private List<FstIndexShardStats> stats = Lists.newArrayList();

    public List<FstIndexShardStats> getStats() {
        return this.stats;
    }

    public void readFrom(StreamInput in) throws IOException {
        long size = in.readLong();
        int i = 0;
        while ((long)i < size) {
            FstIndexShardStats fstIndexShardStats = new FstIndexShardStats();
            fstIndexShardStats.readFrom(in);
            this.stats.add(fstIndexShardStats);
            ++i;
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong((long)this.stats.size());
        for (FstIndexShardStats fstIndexShardStats : this.stats) {
            fstIndexShardStats.writeTo(out);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("fstStats");
        for (FstIndexShardStats fstIndexShardStats : this.stats) {
            fstIndexShardStats.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public static class FstIndexShardStats
    implements Streamable,
    Serializable,
    ToXContent {
        private ShardId shardId;
        private String type;
        private ShardSuggestService.FieldType fieldType;
        private long sizeInBytes;

        public FstIndexShardStats() {
        }

        public FstIndexShardStats(ShardId shardId, String type, ShardSuggestService.FieldType fieldType, long sizeInBytes) {
            this.shardId = shardId;
            this.type = type;
            this.fieldType = fieldType;
            this.sizeInBytes = sizeInBytes;
        }

        public ShardId getShardId() {
            return this.shardId;
        }

        public String getType() {
            return this.type;
        }

        public ShardSuggestService.FieldType getFieldType() {
            return this.fieldType;
        }

        public long getSizeInBytes() {
            return this.sizeInBytes;
        }

        public void readFrom(StreamInput in) throws IOException {
            this.type = in.readString();
            this.sizeInBytes = in.readLong();
            this.shardId = ShardId.readShardId((StreamInput)in);
            this.fieldType = new ShardSuggestService.FieldType();
            this.fieldType.readFrom(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.type);
            out.writeLong(this.sizeInBytes);
            this.shardId.writeTo(out);
            this.fieldType.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("index", this.shardId.getIndex());
            builder.field("id", this.shardId.getId());
            builder.field("sizeInBytes", this.sizeInBytes);
            builder.field("type", this.type);
            this.fieldType.toXContent(builder, params);
            builder.endObject();
            return builder;
        }
    }
}

