/*
 * Decompiled with CFR 0.152.
 */
package de.spinscale.elasticsearch.action.suggest.suggest;

import de.spinscale.elasticsearch.action.suggest.suggest.ShardSuggestRequest;
import de.spinscale.elasticsearch.action.suggest.suggest.ShardSuggestResponse;
import de.spinscale.elasticsearch.action.suggest.suggest.SuggestRequest;
import de.spinscale.elasticsearch.action.suggest.suggest.SuggestResponse;
import de.spinscale.elasticsearch.service.suggest.ShardSuggestService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.TransportBroadcastOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableSortedSet;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.IndexShardException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportSuggestAction
extends TransportBroadcastOperationAction<SuggestRequest, SuggestResponse, ShardSuggestRequest, ShardSuggestResponse> {
    private final IndicesService indicesService;

    @Inject
    public TransportSuggestAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService) {
        super(settings, threadPool, clusterService, transportService);
        this.indicesService = indicesService;
    }

    protected String transportAction() {
        return "suggest-fst";
    }

    protected String executor() {
        return "search";
    }

    protected SuggestRequest newRequest() {
        return new SuggestRequest();
    }

    protected SuggestResponse newResponse(SuggestRequest request, AtomicReferenceArray shardsResponses, ClusterState clusterState) {
        this.logger.trace("Entered TransportSuggestAction.newResponse()", new Object[0]);
        int successfulShards = 0;
        int failedShards = 0;
        ArrayList shardFailures = null;
        ArrayList items = Lists.newArrayList();
        for (int i = 0; i < shardsResponses.length(); ++i) {
            Object shardResponse = shardsResponses.get(i);
            if (shardResponse == null) {
                ++failedShards;
                continue;
            }
            if (shardResponse instanceof BroadcastShardOperationFailedException) {
                ++failedShards;
                if (shardFailures == null) {
                    shardFailures = Lists.newArrayList();
                }
                shardFailures.add(new DefaultShardOperationFailedException((IndexShardException)((BroadcastShardOperationFailedException)shardResponse)));
                continue;
            }
            if (shardResponse instanceof ShardSuggestResponse) {
                ShardSuggestResponse shardSuggestResponse = (ShardSuggestResponse)((Object)shardResponse);
                List<String> shardItems = shardSuggestResponse.suggestions();
                items.addAll(shardItems);
                ++successfulShards;
                continue;
            }
            ++successfulShards;
        }
        ImmutableList resultItems = ImmutableSortedSet.copyOf((Collection)items).asList();
        return new SuggestResponse(resultItems.subList(0, Math.min(resultItems.size(), request.size())), shardsResponses.length(), successfulShards, failedShards, shardFailures);
    }

    protected ShardSuggestRequest newShardRequest() {
        return new ShardSuggestRequest();
    }

    protected ShardSuggestRequest newShardRequest(ShardRouting shard, SuggestRequest request) {
        return new ShardSuggestRequest(shard.index(), shard.id(), request);
    }

    protected ShardSuggestResponse newShardResponse() {
        return new ShardSuggestResponse();
    }

    protected ShardSuggestResponse shardOperation(ShardSuggestRequest request) throws ElasticSearchException {
        this.logger.trace("Entered TransportSuggestAction.shardOperation()", new Object[0]);
        IndexService indexService = this.indicesService.indexServiceSafe(request.index());
        ShardSuggestService suggestShardService = (ShardSuggestService)((Object)indexService.shardInjectorSafe(request.shardId()).getInstance(ShardSuggestService.class));
        return suggestShardService.suggest(request);
    }

    protected GroupShardsIterator shards(ClusterState clusterState, SuggestRequest request, String[] concreteIndices) {
        this.logger.trace("Entered TransportSuggestAction.shards()", new Object[0]);
        return this.clusterService.operationRouting().searchShards(clusterState, request.indices(), concreteIndices, null, null);
    }

    protected ClusterBlockException checkGlobalBlock(ClusterState state, SuggestRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA);
    }

    protected ClusterBlockException checkRequestBlock(ClusterState state, SuggestRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA, concreteIndices);
    }
}

