/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.service.suggest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.HighFrequencyDictionary;
import org.apache.lucene.search.spell.SpellChecker;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.fst.FSTCompletionLookup;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.elasticsearch.action.suggest.ShardSuggestRefreshRequest;
import org.elasticsearch.action.suggest.ShardSuggestRefreshResponse;
import org.elasticsearch.action.suggest.ShardSuggestRequest;
import org.elasticsearch.action.suggest.ShardSuggestResponse;
import org.elasticsearch.common.base.Function;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.cache.CacheLoader;
import org.elasticsearch.common.cache.LoadingCache;
import org.elasticsearch.common.collect.Collections2;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;

public class ShardSuggestService
extends AbstractIndexShardComponent {
    private final IndexShard indexShard;
    private final ReentrantLock lock = new ReentrantLock();
    private IndexReader indexReader;
    private Engine.Searcher indexSearcher;
    private final LoadingCache<String, FSTCompletionLookup> lookupCache;
    private final LoadingCache<String, HighFrequencyDictionary> dictCache;
    private final LoadingCache<String, SpellChecker> spellCheckerCache;

    @Inject
    public ShardSuggestService(ShardId shardId, @IndexSettings Settings indexSettings, IndexShard indexShard) {
        super(shardId, indexSettings);
        this.indexShard = indexShard;
        this.dictCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, HighFrequencyDictionary>(){

            public HighFrequencyDictionary load(String field) throws Exception {
                return new HighFrequencyDictionary(ShardSuggestService.this.createOrGetIndexReader(), field, 1.0E-5f);
            }
        });
        this.spellCheckerCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, SpellChecker>(){

            public SpellChecker load(String field) throws Exception {
                SpellChecker spellChecker = new SpellChecker((Directory)new RAMDirectory());
                IndexWriterConfig indexWriterConfig = new IndexWriterConfig(Version.LUCENE_36, (Analyzer)new WhitespaceAnalyzer(Version.LUCENE_36));
                spellChecker.indexDictionary((Dictionary)ShardSuggestService.this.dictCache.getUnchecked((Object)field), indexWriterConfig, false);
                return spellChecker;
            }
        });
        this.lookupCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, FSTCompletionLookup>(){

            public FSTCompletionLookup load(String field) throws Exception {
                FSTCompletionLookup lookup = new FSTCompletionLookup();
                lookup.build((Dictionary)ShardSuggestService.this.dictCache.getUnchecked((Object)field));
                return lookup;
            }
        });
    }

    public ShardSuggestRefreshResponse refresh(ShardSuggestRefreshRequest shardSuggestRefreshRequest) {
        String field = shardSuggestRefreshRequest.field();
        if (field == null || field.length() == 0) {
            this.update();
        } else {
            FSTCompletionLookup lookup;
            SpellChecker spellChecker;
            this.resetIndexReader();
            HighFrequencyDictionary dict = (HighFrequencyDictionary)this.dictCache.getIfPresent((Object)field);
            if (dict != null) {
                this.dictCache.refresh((Object)field);
            }
            if ((spellChecker = (SpellChecker)this.spellCheckerCache.getIfPresent((Object)field)) != null) {
                this.spellCheckerCache.refresh((Object)field);
                try {
                    spellChecker.close();
                }
                catch (IOException e) {
                    this.logger.error("Could not close spellchecker in indexshard [{}] for field [{}]", (Throwable)e, new Object[]{this.indexShard, field});
                }
            }
            if ((lookup = (FSTCompletionLookup)this.lookupCache.getIfPresent((Object)field)) != null) {
                this.lookupCache.refresh((Object)field);
            }
        }
        return new ShardSuggestRefreshResponse(this.shardId.index().name(), this.shardId.id());
    }

    public void shutDown() {
        this.resetIndexReader();
        this.dictCache.invalidateAll();
        for (Map.Entry entry : this.spellCheckerCache.asMap().entrySet()) {
            try {
                ((SpellChecker)entry.getValue()).close();
            }
            catch (IOException e) {
                this.logger.error("Could not close spellchecker in indexshard [{}] for field [{}]", (Throwable)e, new Object[]{this.indexShard, entry.getKey()});
            }
        }
        this.spellCheckerCache.invalidateAll();
        this.lookupCache.invalidateAll();
    }

    public void update() {
        this.resetIndexReader();
        for (String field : this.dictCache.asMap().keySet()) {
            this.dictCache.refresh((Object)field);
        }
        try {
            for (String field : this.spellCheckerCache.asMap().keySet()) {
                SpellChecker oldSpellchecker = (SpellChecker)this.spellCheckerCache.getUnchecked((Object)field);
                this.spellCheckerCache.refresh((Object)field);
                oldSpellchecker.close();
            }
        }
        catch (IOException e) {
            this.logger.error("Error refreshing spell checker cache [{}]", (Throwable)e, new Object[]{this.shardId});
        }
        for (String field : this.lookupCache.asMap().keySet()) {
            this.lookupCache.refresh((Object)field);
        }
    }

    public ShardSuggestResponse suggest(ShardSuggestRequest shardSuggestRequest) {
        String field = shardSuggestRequest.field();
        String term = shardSuggestRequest.term();
        int limit = shardSuggestRequest.size();
        ArrayList suggestions = Lists.newArrayList(this.getSuggestions(field, term, limit));
        float similarity = shardSuggestRequest.similarity();
        if (similarity < 1.0f && suggestions.size() < limit) {
            suggestions.addAll(this.getSimilarSuggestions(field, term, limit, similarity));
        }
        return new ShardSuggestResponse(this.shardId.index().name(), this.shardId.id(), suggestions);
    }

    private Collection<String> getSimilarSuggestions(String field, String term, int limit, float similarity) {
        try {
            String[] suggestSimilar = ((SpellChecker)this.spellCheckerCache.getUnchecked((Object)field)).suggestSimilar(term, limit, similarity);
            return Arrays.asList(suggestSimilar);
        }
        catch (IOException e) {
            this.logger.error("Error getting spellchecker suggestions for shard [{}] field [{}] term [{}] limit [{}] similarity [{}]", (Throwable)e, new Object[]{this.shardId, field, term, limit, Float.valueOf(similarity)});
            return Collections.emptyList();
        }
    }

    private Collection<String> getSuggestions(String field, String term, int limit) {
        List lookupResults = ((FSTCompletionLookup)this.lookupCache.getUnchecked((Object)field)).lookup((CharSequence)term, true, limit + 1);
        return Collections2.transform((Collection)lookupResults, (Function)new LookupResultToStringFunction());
    }

    public void resetIndexReader() {
        try {
            IndexReader oldIndexReader = this.indexReader;
            this.indexReader = null;
            if (oldIndexReader != null) {
                IndexReader maybeNewIndexReader = oldIndexReader.reopen();
                oldIndexReader.close();
                if (!maybeNewIndexReader.equals(oldIndexReader)) {
                    maybeNewIndexReader.close();
                }
            }
        }
        catch (IOException e) {
            this.logger.error("Error resetting index reader [{}]", (Throwable)e, new Object[]{this.shardId});
        }
        try {
            Engine.Searcher oldIndexSearcher = this.indexSearcher;
            this.indexSearcher = null;
            if (oldIndexSearcher != null) {
                oldIndexSearcher.reader().close();
                oldIndexSearcher.release();
            }
        }
        catch (IOException e) {
            this.logger.error("Error resetting index searcher [{}]", (Throwable)e, new Object[]{this.shardId});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexReader createOrGetIndexReader() {
        try {
            if (this.indexSearcher == null) {
                this.lock.lock();
                if (this.indexSearcher == null) {
                    this.indexReader = this.indexShard.searcher().reader().clone(true);
                    this.indexSearcher = this.indexShard.searcher();
                }
            }
        }
        catch (IOException e) {
            this.logger.error("Error cloning index reader: [{}]", (Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            if (this.lock.isLocked()) {
                this.lock.unlock();
            }
        }
        return this.indexReader;
    }

    private class LookupResultToStringFunction
    implements Function<Lookup.LookupResult, String> {
        private LookupResultToStringFunction() {
        }

        public String apply(Lookup.LookupResult result) {
            return ((Object)result.key).toString();
        }
    }
}

