/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.suggest;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.suggest.SuggestAction;
import org.elasticsearch.action.suggest.SuggestRequest;
import org.elasticsearch.action.suggest.SuggestResponse;
import org.elasticsearch.action.support.broadcast.BroadcastOperationResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestSuggestAction
extends BaseRestHandler {
    @Inject
    public RestSuggestAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_suggest", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_suggest", (RestHandler)this);
    }

    public void handleRequest(final RestRequest request, final RestChannel channel) {
        String[] indices = RestActions.splitIndices((String)request.param("index"));
        try {
            XContentParser parser = XContentFactory.xContent((BytesReference)request.content()).createParser(request.content());
            Map parserMap = parser.mapAndClose();
            SuggestRequest suggestRequest = new SuggestRequest(indices);
            suggestRequest.field(XContentMapValues.nodeStringValue(parserMap.get("field"), (String)""));
            suggestRequest.term(XContentMapValues.nodeStringValue(parserMap.get("term"), (String)""));
            suggestRequest.similarity(XContentMapValues.nodeFloatValue(parserMap.get("similarity"), (float)1.0f));
            suggestRequest.size(XContentMapValues.nodeIntegerValue(parserMap.get("size"), (int)10));
            this.client.execute((Action)SuggestAction.INSTANCE, (ActionRequest)suggestRequest, (ActionListener)new ActionListener<SuggestResponse>(){

                public void onResponse(SuggestResponse response) {
                    try {
                        XContentBuilder builder = RestXContentBuilder.restContentBuilder((RestRequest)request);
                        builder.startObject();
                        builder.field("suggestions", response.suggestions());
                        RestActions.buildBroadcastShardsHeader((XContentBuilder)builder, (BroadcastOperationResponse)response);
                        builder.endObject();
                        channel.sendResponse((RestResponse)new XContentRestResponse(request, RestStatus.OK, builder));
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse((RestResponse)new XContentThrowableRestResponse(request, e));
                    }
                    catch (IOException e1) {
                        RestSuggestAction.this.logger.error("Failed to send failure response", (Throwable)e1, new Object[0]);
                    }
                }
            });
        }
        catch (IOException e) {
            try {
                channel.sendResponse((RestResponse)new XContentThrowableRestResponse(request, (Throwable)e));
            }
            catch (IOException e1) {
                this.logger.error("Failed to send failure response", (Throwable)e1, new Object[0]);
            }
        }
    }
}

