/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.suggest;

import java.util.ArrayList;
import java.util.Collection;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.module.suggest.ShardSuggestModule;
import org.elasticsearch.module.suggest.SuggestClientModule;
import org.elasticsearch.module.suggest.SuggestModule;
import org.elasticsearch.plugins.AbstractPlugin;
import org.elasticsearch.rest.RestModule;
import org.elasticsearch.rest.action.suggest.RestRefreshSuggestAction;
import org.elasticsearch.rest.action.suggest.RestSuggestAction;
import org.elasticsearch.service.suggest.SuggestService;

public class SuggestPlugin
extends AbstractPlugin {
    private final Settings settings;

    @Inject
    public SuggestPlugin(Settings settings) {
        this.settings = settings;
    }

    public String name() {
        return "suggest";
    }

    public String description() {
        return "Suggest Plugin";
    }

    public void onModule(RestModule restModule) {
        restModule.addRestAction(RestSuggestAction.class);
        restModule.addRestAction(RestRefreshSuggestAction.class);
    }

    public Collection<Class<? extends LifecycleComponent>> services() {
        ArrayList services = Lists.newArrayList();
        if (!this.isClient()) {
            services.add(SuggestService.class);
        }
        return services;
    }

    public Collection<Class<? extends Module>> modules() {
        ArrayList modules = Lists.newArrayList();
        if (this.isClient()) {
            modules.add(SuggestClientModule.class);
        } else {
            modules.add(SuggestModule.class);
        }
        return modules;
    }

    public Collection<Class<? extends Module>> shardModules() {
        ArrayList modules = Lists.newArrayList();
        modules.add(ShardSuggestModule.class);
        return modules;
    }

    private boolean isClient() {
        return this.settings.getAsBoolean("node.client", Boolean.valueOf(false));
    }
}

