/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.service.suggest;

import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.suggest.SuggestRefreshRequest;
import org.elasticsearch.action.suggest.TransportSuggestRefreshAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.StopWatch;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesLifecycle;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.service.suggest.ShardSuggestService;

public class SuggestService
extends AbstractLifecycleComponent<SuggestService> {
    private final TimeValue suggestRefreshInterval;
    private final boolean suggestRefreshDisabled;
    private volatile Thread suggestUpdaterThread;
    private volatile boolean closed;
    private final TransportSuggestRefreshAction suggestRefreshAction;
    private final ClusterService clusterService;
    private final IndicesService indicesService;

    @Inject
    public SuggestService(Settings settings, TransportSuggestRefreshAction suggestRefreshAction, ClusterService clusterService, IndicesService indicesService) {
        super(settings);
        this.suggestRefreshAction = suggestRefreshAction;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.suggestRefreshDisabled = settings.getAsBoolean("suggest.refresh_disabled", Boolean.valueOf(false));
        this.suggestRefreshInterval = settings.getAsTime("suggest.refresh_interval", TimeValue.timeValueMinutes((long)10L));
    }

    protected void doStart() throws ElasticSearchException {
        if (this.suggestRefreshDisabled) {
            this.logger.info("Suggest component started with out refreshing automatically", new Object[0]);
        } else {
            this.suggestUpdaterThread = EsExecutors.daemonThreadFactory((Settings)this.settings, (String)"suggest_updater").newThread(new SuggestUpdaterThread());
            this.suggestUpdaterThread.start();
            this.logger.info("Suggest component started with refresh interval [{}]", new Object[]{this.suggestRefreshInterval});
        }
        this.indicesService.indicesLifecycle().addListener(new IndicesLifecycle.Listener(){

            public void beforeIndexClosed(IndexService indexService, boolean delete) {
                for (IndexShard indexShard : indexService) {
                    ShardSuggestService suggestShardService = (ShardSuggestService)((Object)indexService.shardInjectorSafe(indexShard.shardId().id()).getInstance(ShardSuggestService.class));
                    suggestShardService.shutDown();
                }
            }
        });
        this.indicesService.indicesLifecycle().addListener(new IndicesLifecycle.Listener(){

            public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, boolean delete) {
                IndexService indexService = SuggestService.this.indicesService.indexService(shardId.index().name());
                if (indexService != null) {
                    ShardSuggestService suggestShardService = (ShardSuggestService)((Object)indexService.shardInjectorSafe(shardId.id()).getInstance(ShardSuggestService.class));
                    suggestShardService.shutDown();
                }
            }
        });
    }

    protected void doStop() throws ElasticSearchException {
        if (this.closed) {
            return;
        }
        if (this.suggestUpdaterThread != null) {
            this.suggestUpdaterThread.interrupt();
        }
        this.closed = true;
        this.logger.info("Suggest component stopped", new Object[0]);
    }

    protected void doClose() throws ElasticSearchException {
    }

    public class SuggestUpdaterThread
    implements Runnable {
        @Override
        public void run() {
            while (!SuggestService.this.closed) {
                DiscoveryNode node = SuggestService.this.clusterService.localNode();
                boolean isClusterStarted = SuggestService.this.clusterService.lifecycleState().equals((Object)Lifecycle.State.STARTED);
                if (isClusterStarted && node != null && node.isMasterNode()) {
                    StopWatch sw = new StopWatch().start();
                    SuggestService.this.suggestRefreshAction.execute((ActionRequest)new SuggestRefreshRequest()).actionGet();
                    SuggestService.this.logger.info("Suggest update took [{}], next update in [{}]", new Object[]{sw.stop().totalTime(), SuggestService.this.suggestRefreshInterval});
                } else if (node != null) {
                    SuggestService.this.logger.debug("[{}]/[{}] is not master node, not triggering update", new Object[]{node.getId(), node.getName()});
                }
                try {
                    Thread.sleep(SuggestService.this.suggestRefreshInterval.millis());
                }
                catch (InterruptedException e1) {}
            }
        }
    }
}

