/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.suggest;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.suggest.ShardSuggestRefreshRequest;
import org.elasticsearch.action.suggest.ShardSuggestRefreshResponse;
import org.elasticsearch.action.suggest.SuggestRefreshRequest;
import org.elasticsearch.action.suggest.SuggestRefreshResponse;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.TransportBroadcastOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.IndexShardException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.service.suggest.ShardSuggestService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportSuggestRefreshAction
extends TransportBroadcastOperationAction<SuggestRefreshRequest, SuggestRefreshResponse, ShardSuggestRefreshRequest, ShardSuggestRefreshResponse> {
    private final IndicesService indicesService;

    @Inject
    public TransportSuggestRefreshAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService) {
        super(settings, threadPool, clusterService, transportService);
        this.indicesService = indicesService;
    }

    protected String transportAction() {
        return "suggestRefresh";
    }

    protected String executor() {
        return "index";
    }

    protected SuggestRefreshRequest newRequest() {
        return new SuggestRefreshRequest();
    }

    protected SuggestRefreshResponse newResponse(SuggestRefreshRequest request, AtomicReferenceArray shardsResponses, ClusterState clusterState) {
        int successfulShards = 0;
        int failedShards = 0;
        ArrayList shardFailures = Lists.newArrayList();
        for (int i = 0; i < shardsResponses.length(); ++i) {
            Object shardResponse = shardsResponses.get(i);
            if (shardResponse == null) {
                ++failedShards;
                continue;
            }
            if (shardResponse instanceof BroadcastShardOperationFailedException) {
                ++failedShards;
                shardFailures.add(new DefaultShardOperationFailedException((IndexShardException)((BroadcastShardOperationFailedException)shardResponse)));
                continue;
            }
            ++successfulShards;
        }
        return new SuggestRefreshResponse(shardsResponses.length(), successfulShards, failedShards, shardFailures);
    }

    protected ShardSuggestRefreshRequest newShardRequest() {
        return new ShardSuggestRefreshRequest();
    }

    protected ShardSuggestRefreshRequest newShardRequest(ShardRouting shard, SuggestRefreshRequest request) {
        return new ShardSuggestRefreshRequest(shard.index(), shard.id(), request);
    }

    protected ShardSuggestRefreshResponse newShardResponse() {
        return new ShardSuggestRefreshResponse();
    }

    protected ShardSuggestRefreshResponse shardOperation(ShardSuggestRefreshRequest request) throws ElasticSearchException {
        this.logger.trace("Entered TransportSuggestRefreshAction.shardOperation()", new Object[0]);
        IndexService indexService = this.indicesService.indexServiceSafe(request.index());
        ShardSuggestService suggestShardService = (ShardSuggestService)((Object)indexService.shardInjectorSafe(request.shardId()).getInstance(ShardSuggestService.class));
        return suggestShardService.refresh(request);
    }

    protected GroupShardsIterator shards(ClusterState clusterState, SuggestRefreshRequest request, String[] concreteIndices) {
        return this.clusterService.operationRouting().searchShards(clusterState, request.indices(), concreteIndices, null, null, null);
    }

    protected ClusterBlockException checkGlobalBlock(ClusterState state, SuggestRefreshRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA);
    }

    protected ClusterBlockException checkRequestBlock(ClusterState state, SuggestRefreshRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA, concreteIndices);
    }
}

