/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.suggest;

import java.io.IOException;
import org.elasticsearch.action.suggest.SuggestRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ShardSuggestRequest
extends BroadcastShardOperationRequest {
    private int size = 10;
    private String field;
    private float similarity = 1.0f;
    private String term;
    private String[] types = Strings.EMPTY_ARRAY;

    public ShardSuggestRequest() {
    }

    public ShardSuggestRequest(String index, int shardId, SuggestRequest request) {
        super(index, shardId);
        this.size = request.size();
        this.field = request.field();
        this.term = request.term();
        this.similarity = request.similarity();
        this.types = request.types();
    }

    public int size() {
        return this.size;
    }

    public void size(int size) {
        this.size = size;
    }

    public String field() {
        return this.field;
    }

    public void field(String field) {
        this.field = field;
    }

    public float similarity() {
        return this.similarity;
    }

    public void similarity(float similarity) {
        this.similarity = similarity;
    }

    public String term() {
        return this.term;
    }

    public void term(String term) {
        this.term = term;
    }

    public String[] types() {
        return this.types;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.size = in.readVInt();
        this.similarity = in.readFloat();
        this.field = in.readString();
        this.term = in.readString();
        int typesSize = in.readVInt();
        if (typesSize > 0) {
            this.types = new String[typesSize];
            for (int i = 0; i < typesSize; ++i) {
                this.types[i] = in.readString();
            }
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.size);
        out.writeFloat(this.similarity);
        out.writeString(this.field);
        out.writeString(this.term);
        out.writeVInt(this.types.length);
        for (String type : this.types) {
            out.writeString(type);
        }
    }
}

