/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.isolator;

import de.sormuras.junit.platform.isolator.GroupArtifact;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

public enum Version {
    ISOLATOR_VERSION(Version.implementationVersion("1.0.0-M8"), GroupArtifact.ISOLATOR, GroupArtifact.ISOLATOR_WORKER),
    JUNIT_PLATFORM_VERSION("1.3.2", GroupArtifact.JUNIT_PLATFORM_COMMONS),
    JUNIT_JUPITER_VERSION("5.3.2", GroupArtifact.JUNIT_JUPITER_API, GroupArtifact.JUNIT_JUPITER_ENGINE),
    JUNIT_VINTAGE_VERSION("5.3.2", GroupArtifact.JUNIT_VINTAGE_ENGINE);

    private final String key = this.name().toLowerCase().replace('_', '.');
    private final String defaultVersion;
    private final List<GroupArtifact> groupArtifacts;

    public static Map<String, String> buildMap(UnaryOperator<String> versionOperator) {
        HashMap<String, String> result = new HashMap<String, String>();
        block0: for (Version version : Version.values()) {
            String versionKey = version.getKey();
            for (GroupArtifact groupArtifact : version.getGroupArtifacts()) {
                String artifactVersion = (String)versionOperator.apply(groupArtifact.toString());
                if (artifactVersion == null) continue;
                result.put(versionKey, artifactVersion);
                continue block0;
            }
            result.put(versionKey, version.getDefaultVersion());
        }
        return result;
    }

    public static void forEach(Consumer<Version> versionConsumer) {
        Arrays.stream(Version.values()).sorted().forEach(versionConsumer);
    }

    public static String implementationVersion(String defaultVersion) {
        String version = Version.class.getPackage().getImplementationVersion();
        return version != null ? version : defaultVersion;
    }

    private Version(String defaultVersion, GroupArtifact ... groupArtifacts) {
        this.defaultVersion = defaultVersion;
        this.groupArtifacts = Arrays.asList(groupArtifacts);
    }

    public List<GroupArtifact> getGroupArtifacts() {
        return this.groupArtifacts;
    }

    public String getKey() {
        return this.key;
    }

    public String getDefaultVersion() {
        return this.defaultVersion;
    }
}

