/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.isolator;

import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;

public interface Overlay {
    default public URLClassLoader newClassLoader(String name, ClassLoader parent, Collection<Path> paths) {
        URL[] urls = (URL[])paths.stream().map(Path::toUri).map(Overlay::url).toArray(URL[]::new);
        return this.newClassLoader(name, parent, urls);
    }

    public URLClassLoader newClassLoader(String var1, ClassLoader var2, URL ... var3);

    public ClassLoader newModuleLoader(Set<String> var1, ClassLoader var2, Path ... var3);

    public ClassLoader platformClassLoader();

    public static URL url(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException("URI inconvertible to URL: " + uri, e);
        }
    }
}

