/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.isolator;

import de.sormuras.junit.platform.isolator.GroupArtifact;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;

public class Configuration
implements Serializable {
    private final Basic basic = new Basic();
    private final Discovery discovery = new Discovery();
    private final Launcher launcher = new Launcher();

    public Basic basic() {
        return this.basic;
    }

    public Discovery discovery() {
        return this.discovery;
    }

    public Launcher launcher() {
        return this.launcher;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration that = (Configuration)o;
        return this.basic.equals(that.basic) && this.discovery.equals(that.discovery) && this.launcher.equals(that.launcher);
    }

    public int hashCode() {
        return Objects.hash(this.basic, this.discovery, this.launcher);
    }

    public String toString() {
        return "Configuration{basic=" + this.basic + ", discovery=" + this.discovery + ", launcher=" + this.launcher + '}';
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] toBytes() {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream out = new ObjectOutputStream(bos);){
                out.writeObject(this);
                byArray = bos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Writing configuration to byte[] failed", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Configuration fromBytes(byte[] bytes) {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            Configuration configuration;
            try (ObjectInputStream in = new ObjectInputStream(bis);){
                configuration = (Configuration)in.readObject();
            }
            return configuration;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Reading configuration from byte[" + bytes.length + "] failed", e);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError("Configuration class not found?!", e);
        }
    }

    public static class Launcher
    implements Serializable {
        boolean testEngineAutoRegistration = true;
        boolean testExecutionListenerAutoRegistration = true;

        private Launcher() {
        }

        public boolean isTestEngineAutoRegistration() {
            return this.testEngineAutoRegistration;
        }

        public boolean isTestExecutionListenerAutoRegistration() {
            return this.testExecutionListenerAutoRegistration;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Launcher)) {
                return false;
            }
            Launcher launcher = (Launcher)o;
            return this.testEngineAutoRegistration == launcher.testEngineAutoRegistration && this.testExecutionListenerAutoRegistration == launcher.testExecutionListenerAutoRegistration;
        }

        public int hashCode() {
            return Objects.hash(this.testEngineAutoRegistration, this.testExecutionListenerAutoRegistration);
        }

        public String toString() {
            return new StringJoiner(", ", Launcher.class.getSimpleName() + "[", "]").add("testEngineAutoRegistration=" + this.testEngineAutoRegistration).add("testExecutionListenerAutoRegistration=" + this.testExecutionListenerAutoRegistration).toString();
        }
    }

    public static class Discovery
    implements Serializable {
        private static Set<String> DEFAULT_CLASS_NAME_PATTERN = Collections.singleton("^(Test.*|.+[.$]Test.*|.*Tests?)$");
        Set<URI> selectedUris = Collections.emptySet();
        Set<String> selectedFiles = Collections.emptySet();
        Set<String> selectedDirectories = Collections.emptySet();
        Set<String> selectedPackages = Collections.emptySet();
        Set<String> selectedClasses = Collections.emptySet();
        Set<String> selectedMethods = Collections.emptySet();
        Set<String> selectedClasspathResources = Collections.emptySet();
        Set<String> selectedClasspathRoots = Collections.emptySet();
        Set<String> selectedModules = Collections.emptySet();
        Set<String> filterClassNamePatterns = new LinkedHashSet<String>(DEFAULT_CLASS_NAME_PATTERN);
        Set<String> filterTags = Collections.emptySet();
        Map<String, String> parameters = Collections.emptyMap();

        private Discovery() {
        }

        public Set<URI> getSelectedUris() {
            return this.selectedUris;
        }

        public Set<String> getSelectedFiles() {
            return this.selectedFiles;
        }

        public Set<String> getSelectedDirectories() {
            return this.selectedDirectories;
        }

        public Set<String> getSelectedPackages() {
            return this.selectedPackages;
        }

        public Set<String> getSelectedClasses() {
            return this.selectedClasses;
        }

        public Set<String> getSelectedMethods() {
            return this.selectedMethods;
        }

        public Set<String> getSelectedClasspathResources() {
            return this.selectedClasspathResources;
        }

        public Set<String> getSelectedClasspathRoots() {
            return this.selectedClasspathRoots;
        }

        public Set<String> getSelectedModules() {
            return this.selectedModules;
        }

        public Set<String> getFilterClassNamePatterns() {
            return this.filterClassNamePatterns;
        }

        public Set<String> getFilterTags() {
            return this.filterTags;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Discovery discovery = (Discovery)o;
            return this.selectedUris.equals(discovery.selectedUris) && this.selectedFiles.equals(discovery.selectedFiles) && this.selectedDirectories.equals(discovery.selectedDirectories) && this.selectedPackages.equals(discovery.selectedPackages) && this.selectedClasses.equals(discovery.selectedClasses) && this.selectedMethods.equals(discovery.selectedMethods) && this.selectedClasspathResources.equals(discovery.selectedClasspathResources) && this.selectedClasspathRoots.equals(discovery.selectedClasspathRoots) && this.selectedModules.equals(discovery.selectedModules) && this.filterClassNamePatterns.equals(discovery.filterClassNamePatterns) && this.filterTags.equals(discovery.filterTags) && this.parameters.equals(discovery.parameters);
        }

        public int hashCode() {
            return Objects.hash(this.selectedUris, this.selectedFiles, this.selectedDirectories, this.selectedPackages, this.selectedClasses, this.selectedMethods, this.selectedClasspathResources, this.selectedClasspathRoots, this.selectedModules, this.filterClassNamePatterns, this.filterTags, this.parameters);
        }

        public String toString() {
            return new StringJoiner(", ", Discovery.class.getSimpleName() + "[", "]").add("selectedUris=" + this.selectedUris).add("selectedFiles=" + this.selectedFiles).add("selectedDirectories=" + this.selectedDirectories).add("selectedPackages=" + this.selectedPackages).add("selectedClasses=" + this.selectedClasses).add("selectedMethods=" + this.selectedMethods).add("selectedClasspathResources=" + this.selectedClasspathResources).add("selectedClasspathRoots=" + this.selectedClasspathRoots).add("selectedModules=" + this.selectedModules).add("filterClassNamePatterns=" + this.filterClassNamePatterns).add("filterTags=" + this.filterTags).add("parameters=" + this.parameters).toString();
        }
    }

    public static class Basic
    implements Serializable {
        boolean dryRun = false;
        boolean failIfNoTests = true;
        boolean platformClassLoader = true;
        boolean defaultAssertionStatus = true;
        String targetDirectory = "target/junit-platform";
        String workerCoordinates = GroupArtifact.ISOLATOR_WORKER.toStringWithDefaultVersion();
        String workerClassName = "de.sormuras.junit.platform.isolator.worker.Worker";

        public boolean isDryRun() {
            return this.dryRun;
        }

        public boolean isFailIfNoTests() {
            return this.failIfNoTests;
        }

        public boolean isPlatformClassLoader() {
            return this.platformClassLoader;
        }

        public boolean isDefaultAssertionStatus() {
            return this.defaultAssertionStatus;
        }

        public String getTargetDirectory() {
            return this.targetDirectory;
        }

        public String getWorkerCoordinates() {
            return this.workerCoordinates;
        }

        public String getWorkerClassName() {
            return this.workerClassName;
        }

        private Basic() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Basic)) {
                return false;
            }
            Basic basic = (Basic)o;
            return this.dryRun == basic.dryRun && this.failIfNoTests == basic.failIfNoTests && this.platformClassLoader == basic.platformClassLoader && this.defaultAssertionStatus == basic.defaultAssertionStatus && this.targetDirectory.equals(basic.targetDirectory) && this.workerCoordinates.equals(basic.workerCoordinates) && this.workerClassName.equals(basic.workerClassName);
        }

        public int hashCode() {
            return Objects.hash(this.workerCoordinates, this.workerClassName, this.targetDirectory, this.dryRun, this.failIfNoTests, this.platformClassLoader, this.defaultAssertionStatus);
        }

        public String toString() {
            return new StringJoiner(", ", Basic.class.getSimpleName() + "[", "]").add("dryRun=" + this.dryRun).add("failIfNoTests=" + this.failIfNoTests).add("platformClassLoader=" + this.platformClassLoader).add("defaultAssertionStatus=" + this.defaultAssertionStatus).add("targetDirectory='" + this.targetDirectory + "'").add("workerCoordinates='" + this.workerCoordinates + "'").add("workerClassName='" + this.workerClassName + "'").toString();
        }
    }
}

