/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.isolator;

import de.sormuras.junit.platform.isolator.Overlay;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Set;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public enum OverlaySingleton implements Overlay
{
    INSTANCE{

        @Override
        public URLClassLoader newClassLoader(String name, ClassLoader parent, URL ... urls) {
            return new URLClassLoader(name, urls, parent);
        }

        @Override
        public ClassLoader newModuleLoader(Set<String> modules, ClassLoader parent, Path ... entries) {
            ModuleFinder finder = ModuleFinder.of(entries);
            ModuleLayer bootLayer = ModuleLayer.boot();
            Configuration configuration = bootLayer.configuration().resolve(finder, ModuleFinder.of(new Path[0]), modules);
            ClassLoader parentLoader = ClassLoader.getSystemClassLoader();
            ModuleLayer configuredLayer = bootLayer.defineModulesWithOneLoader(configuration, parentLoader);
            String name = "de.sormuras.junit.platform.isolator.worker";
            return configuredLayer.findLoader(name);
        }

        @Override
        public ClassLoader platformClassLoader() {
            return ClassLoader.getPlatformClassLoader();
        }
    };

}

