/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.maven.plugin;

import de.sormuras.junit.platform.isolator.Configuration;
import de.sormuras.junit.platform.isolator.Driver;
import de.sormuras.junit.platform.isolator.GroupArtifact;
import de.sormuras.junit.platform.maven.plugin.JUnitPlatformMojo;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;

class MavenDriver
implements Driver {
    private final JUnitPlatformMojo mojo;
    private final Configuration configuration;
    private final Map<String, Set<Path>> paths;
    private final List<RemoteRepository> repositories;
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession session;

    MavenDriver(JUnitPlatformMojo mojo, Configuration configuration) {
        this.mojo = mojo;
        this.configuration = configuration;
        this.repositories = new ArrayList<RemoteRepository>();
        this.repositories.addAll(mojo.getMavenProject().getRemotePluginRepositories());
        this.repositories.addAll(mojo.getMavenProject().getRemoteProjectRepositories());
        this.repositorySystem = mojo.getMavenResolver();
        this.session = mojo.getMavenRepositorySession();
        this.paths = new LinkedHashMap<String, Set<Path>>();
    }

    public void debug(String format, Object ... objects) {
        this.mojo.debug(format, objects);
    }

    public void info(String format, Object ... objects) {
        this.mojo.info(format, objects);
    }

    public void warn(String format, Object ... objects) {
        this.mojo.warn(format, objects);
    }

    public void error(String format, Object ... objects) {
        this.mojo.error(format, objects);
    }

    public Map<String, Set<Path>> paths() {
        if (!this.paths.isEmpty()) {
            return this.paths;
        }
        LinkedHashSet mainPaths = new LinkedHashSet();
        LinkedHashSet<Path> testPaths = new LinkedHashSet<Path>();
        LinkedHashSet<Path> launcherPaths = new LinkedHashSet<Path>();
        LinkedHashSet<Path> isolatorPaths = new LinkedHashSet<Path>();
        try {
            this.mojo.getMavenProject().getCompileClasspathElements().stream().map(x$0 -> Paths.get(x$0, new String[0])).forEach(mainPaths::add);
            this.mojo.getMavenProject().getTestClasspathElements().stream().map(x$0 -> Paths.get(x$0, new String[0])).forEach(testPaths::add);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new RuntimeException("Resolution required!", e);
        }
        try {
            if (!this.contains(GroupArtifact.JUNIT_PLATFORM_LAUNCHER)) {
                launcherPaths.addAll(this.resolve(GroupArtifact.JUNIT_PLATFORM_LAUNCHER.toString(this.mojo::version)));
            }
            if (this.contains(GroupArtifact.JUNIT_JUPITER_API) && !this.contains(GroupArtifact.JUNIT_JUPITER_ENGINE)) {
                launcherPaths.addAll(this.resolve(GroupArtifact.JUNIT_JUPITER_ENGINE.toString(this.mojo::version)));
            }
            if (this.contains("junit:junit") && !this.contains(GroupArtifact.JUNIT_VINTAGE_ENGINE)) {
                launcherPaths.addAll(this.resolve(GroupArtifact.JUNIT_VINTAGE_ENGINE.toString(this.mojo::version)));
            }
            isolatorPaths.addAll(this.resolve(this.configuration.basic().getWorkerCoordinates()));
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Resolution failed!", e);
        }
        if (this.mojo.isReunite()) {
            Path mainClasses = Paths.get(this.mojo.getMavenProject().getBuild().getOutputDirectory(), new String[0]);
            if (!mainPaths.remove(mainClasses)) {
                this.warn("Main compile target output directory not part of projects compile classpath elements: {0}", mainClasses);
            }
            testPaths.add(mainClasses);
        }
        if (!mainPaths.isEmpty()) {
            this.paths.put("main", mainPaths);
        }
        if (!testPaths.isEmpty()) {
            this.paths.put("test", testPaths);
        }
        if (!launcherPaths.isEmpty()) {
            this.paths.put("launcher", launcherPaths);
        }
        this.paths.put("isolator", isolatorPaths);
        MavenDriver.pruneDuplicates(this.paths);
        if (!this.mojo.isIsolate()) {
            LinkedHashSet allPaths = new LinkedHashSet();
            this.paths.values().forEach(allPaths::addAll);
            this.paths.clear();
            this.paths.put("all", allPaths);
        }
        return this.paths;
    }

    private boolean contains(GroupArtifact groupArtifact) {
        return this.contains(groupArtifact.toString());
    }

    private boolean contains(String groupArtifact) {
        return this.mojo.getMavenProject().getArtifactMap().containsKey(groupArtifact);
    }

    public Set<Path> resolve(String coordinates) throws RepositoryException {
        return this.resolve(coordinates, "", (all, ways) -> true).stream().map(Artifact::getFile).map(File::toPath).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private List<Artifact> resolve(String coordinates, String scope, DependencyFilter filter) throws RepositoryException {
        DefaultArtifact artifact = new DefaultArtifact(coordinates);
        this.debug("Resolving artifact {0} from {1}...", artifact, this.repositories);
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency((Artifact)artifact, scope));
        collectRequest.setRepositories(this.repositories);
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, filter);
        this.debug("Resolving dependencies {0}...", dependencyRequest);
        return this.repositorySystem.resolveDependencies(this.session, dependencyRequest).getArtifactResults().stream().map(ArtifactResult::getArtifact).peek(a -> this.debug("Artifact {0} resolved to {1}", a, a.getFile())).collect(Collectors.toList());
    }

    static <T> void pruneDuplicates(Map<String, ? extends Collection<T>> paths) {
        Set<String> keys = paths.keySet();
        for (String outer : keys) {
            for (String inner : keys) {
                if (outer.equals(inner)) continue;
                paths.get(inner).removeAll(paths.get(outer));
            }
        }
    }
}

