/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.maven.plugin;

import de.sormuras.junit.platform.isolator.Configuration;
import de.sormuras.junit.platform.isolator.ConfigurationBuilder;
import de.sormuras.junit.platform.isolator.Driver;
import de.sormuras.junit.platform.isolator.Isolator;
import de.sormuras.junit.platform.isolator.Modules;
import de.sormuras.junit.platform.isolator.TestMode;
import de.sormuras.junit.platform.isolator.Version;
import de.sormuras.junit.platform.maven.plugin.MavenDriver;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;

@Component(role=AbstractMavenLifecycleParticipant.class)
@org.apache.maven.plugins.annotations.Mojo(name="launch-junit-platform", defaultPhase=LifecyclePhase.TEST, threadSafe=true, requiresDependencyCollection=ResolutionScope.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class JUnitPlatformMojo
extends AbstractMavenLifecycleParticipant
implements Mojo {
    @Parameter(defaultValue="false")
    private boolean skip = false;
    @Parameter(defaultValue="true")
    private boolean isolate = true;
    @Parameter(defaultValue="true")
    private boolean reunite = true;
    @Parameter(defaultValue="false")
    private boolean dryRun = false;
    @Parameter(defaultValue="300")
    private long timeout;
    @Parameter
    private Map<String, String> versions = Collections.emptyMap();
    @Parameter(defaultValue="${project.build}", readonly=true, required=true)
    private Build mavenBuild;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession mavenRepositorySession;
    @org.apache.maven.plugins.annotations.Component
    private RepositorySystem mavenResolver;
    @Parameter
    private Map<String, String> parameters = Collections.emptyMap();
    @Parameter
    private List<String> tags = Collections.emptyList();
    private Log log;
    private Modules projectModules;
    private Map<String, String> projectVersions;

    public void setLog(Log log) {
        this.log = log;
    }

    public Log getLog() {
        if (this.log == null) {
            this.log = new SystemStreamLog();
        }
        return this.log;
    }

    void debug(String format, Object ... args) {
        this.getLog().debug((CharSequence)JUnitPlatformMojo.formatMessage(format, args));
    }

    private void debug(String caption, Collection<Path> paths) {
        this.debug(caption, new Object[0]);
        paths.forEach(path -> this.debug(String.format("  %-50s -> %s", path.getFileName(), path), new Object[0]));
    }

    void info(String format, Object ... args) {
        this.getLog().info((CharSequence)JUnitPlatformMojo.formatMessage(format, args));
    }

    void warn(String format, Object ... args) {
        this.getLog().warn((CharSequence)JUnitPlatformMojo.formatMessage(format, args));
    }

    void error(String format, Object ... args) {
        this.getLog().error((CharSequence)JUnitPlatformMojo.formatMessage(format, args));
    }

    private static String formatMessage(String pattern, Object ... args) {
        if (args.length == 0) {
            return pattern;
        }
        try {
            return MessageFormat.format(pattern, args);
        }
        catch (IllegalArgumentException e) {
            return pattern + " " + Arrays.asList(args) + " // " + e.getClass() + ": " + e.getMessage();
        }
    }

    public void afterProjectsRead(MavenSession session) {
        for (MavenProject project : session.getProjects()) {
            Optional<Plugin> thisPlugin = this.findPlugin(project, "de.sormuras", "junit-platform-maven-plugin");
            thisPlugin.ifPresent(plugin -> this.injectThisPluginIntoTestExecutionPhase(project, (Plugin)plugin));
        }
    }

    private void injectThisPluginIntoTestExecutionPhase(MavenProject project, Plugin thisPlugin) {
        PluginExecution execution = new PluginExecution();
        execution.setId("injected-junit-platform-maven-plugin");
        execution.getGoals().add("launch-junit-platform");
        execution.setPhase("test");
        execution.setConfiguration(thisPlugin.getConfiguration());
        thisPlugin.getExecutions().add(execution);
        Optional<Plugin> surefirePlugin = this.findPlugin(project, "org.apache.maven.plugins", "maven-surefire-plugin");
        surefirePlugin.ifPresent(surefire -> surefire.getExecutions().clear());
    }

    private Optional<Plugin> findPlugin(MavenProject project, String group, String artifact) {
        List plugins = project.getModel().getBuild().getPlugins();
        return plugins.stream().filter(plugin -> group.equals(plugin.getGroupId())).filter(plugin -> artifact.equals(plugin.getArtifactId())).reduce((u, v) -> {
            throw new IllegalStateException("Plugin is not unique: " + artifact);
        });
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        int result;
        this.debug("Executing JUnitPlatformMojo...", new Object[0]);
        if (this.skip) {
            this.info("JUnit Platform Plugin execution skipped.", new Object[0]);
            return;
        }
        if (this.mavenProject.getPackaging().equals("pom")) {
            this.info("JUnit Platform Plugin execution skipped: project uses 'pom' packaging", new Object[0]);
            return;
        }
        Path mainPath = Paths.get(this.mavenBuild.getOutputDirectory(), new String[0]);
        Path testPath = Paths.get(this.mavenBuild.getTestOutputDirectory(), new String[0]);
        this.projectModules = new Modules(mainPath, testPath);
        this.projectVersions = Version.buildMap(this::artifactVersionOrNull);
        this.info("Launching JUnit Platform " + this.version(Version.JUNIT_PLATFORM_VERSION) + "...", new Object[0]);
        if (this.getLog().isDebugEnabled()) {
            this.debug("Path", new Object[0]);
            this.debug("  java.home = {0}", System.getProperty("java.home"));
            this.debug("  user.dir = {0}", System.getProperty("user.dir"));
            this.debug("  project.basedir = {0}", this.mavenProject.getBasedir());
            this.debug("Class Loader", new Object[0]);
            this.debug("  class loader = {0}", ((Object)((Object)this)).getClass().getClassLoader());
            this.debug("  context loader = {0}", Thread.currentThread().getContextClassLoader());
            this.debug("Artifact Map", new Object[0]);
            this.mavenProject.getArtifactMap().keySet().stream().sorted().forEach(k -> this.debug(String.format("  %-50s -> %s", k, this.mavenProject.getArtifactMap().get(k)), new Object[0]));
            this.debug("Version", new Object[0]);
            this.debug("  java.version = {0}", System.getProperty("java.version"));
            this.debug("  java.class.version = {0}", System.getProperty("java.class.version"));
            Version.forEach(v -> this.debug("  {0} = {1}", v.getKey(), this.version((Version)v)));
            this.debug("Java Module System", new Object[0]);
            this.debug("  main -> {0}", this.projectModules.toStringMainModule());
            this.debug("  test -> {0}", this.projectModules.toStringTestModule());
            this.debug("  mode -> {0}", this.projectModules.getMode());
        }
        if (Files.notExists(Paths.get(this.mavenBuild.getTestOutputDirectory(), new String[0]), new LinkOption[0])) {
            this.info("Test output directory does not exist.", new Object[0]);
            return;
        }
        Path targetPath = Paths.get(this.mavenProject.getBuild().getDirectory(), "/junit-platform");
        try {
            Files.createDirectories(targetPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't create target path: " + targetPath, (Exception)e);
        }
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder().setDryRun(this.isDryRun()).setTargetDirectory(targetPath.toString()).discovery().setFilterTagsIncluded(this.tags).setParameters(this.parameters).end();
        TestMode mode = this.projectModules.getMode();
        if (mode == TestMode.CLASSIC) {
            Set<String> roots = Collections.singleton(this.mavenBuild.getTestOutputDirectory());
            configurationBuilder.discovery().setSelectedClasspathRoots(roots);
        } else {
            String module = mode == TestMode.MODULAR_PATCHED_TEST_RUNTIME ? (String)this.projectModules.getMainModuleName().orElseThrow(AssertionError::new) : (String)this.projectModules.getTestModuleName().orElseThrow(AssertionError::new);
            Set<String> modules = Collections.singleton(module);
            configurationBuilder.discovery().setSelectedModules(modules);
        }
        Configuration configuration = configurationBuilder.build();
        MavenDriver driver = new MavenDriver(this, configuration);
        if (this.getLog().isDebugEnabled()) {
            this.debug("Path", new Object[0]);
            driver.paths().forEach(this::debug);
        }
        if ((result = this.execute(driver, configuration)) != 0) {
            throw new MojoFailureException("RED ALERT!");
        }
    }

    private int execute(Driver driver, Configuration configuration) throws MojoFailureException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Integer> future = executor.submit(() -> new Isolator(driver).evaluate(configuration));
        try {
            int n = future.get(this.timeout, TimeUnit.SECONDS);
            return n;
        }
        catch (TimeoutException e) {
            this.warn("Global timeout of {0} seconds reached.", this.timeout);
            throw new MojoFailureException("Global timeout reached.", (Throwable)e);
        }
        catch (Exception e) {
            throw new MojoFailureException("Execution failed!", (Throwable)e);
        }
        finally {
            executor.shutdownNow();
        }
    }

    MavenProject getMavenProject() {
        return this.mavenProject;
    }

    RepositorySystemSession getMavenRepositorySession() {
        return this.mavenRepositorySession;
    }

    RepositorySystem getMavenResolver() {
        return this.mavenResolver;
    }

    Map<String, String> getVersions() {
        return this.versions;
    }

    boolean isDryRun() {
        return this.dryRun;
    }

    boolean isIsolate() {
        return this.isolate;
    }

    boolean isReunite() {
        return this.reunite;
    }

    private String artifactVersionOrNull(String key) {
        Artifact artifact = (Artifact)this.mavenProject.getArtifactMap().get(key);
        if (artifact == null) {
            return null;
        }
        return artifact.getBaseVersion();
    }

    String version(Version version) {
        String detectedVersion = this.projectVersions.get(version.getKey());
        return this.versions.getOrDefault(version.getKey(), detectedVersion);
    }
}

