/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.maven.plugin;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.maven.plugins.annotations.Parameter;

public class FileNames {
    @Parameter
    private String consoleLauncherCmdLog = "console-launcher.cmd.log";
    @Parameter
    private String consoleLauncherErrLog = "console-launcher.err.log";
    @Parameter
    private String consoleLauncherOutLog = "console-launcher.out.log";
    @Parameter
    private String moduleInfoTest = "module-info.test";

    String getConsoleLauncherCmdLog() {
        return this.consoleLauncherCmdLog;
    }

    String getConsoleLauncherErrLog() {
        return this.consoleLauncherErrLog;
    }

    String getConsoleLauncherOutLog() {
        return this.consoleLauncherOutLog;
    }

    String getModuleInfoTest() {
        return this.moduleInfoTest;
    }

    Optional<Path> resolveModuleInfoTest(Set<Path> roots) {
        for (Path root : roots) {
            Path candidate = root.resolve(this.getModuleInfoTest());
            if (!Files.exists(candidate, new LinkOption[0])) continue;
            return Optional.of(candidate);
        }
        return Optional.empty();
    }

    public String toString() {
        return new StringJoiner(", ", FileNames.class.getSimpleName() + "[", "]").add("consoleLauncherCmdLog='" + this.consoleLauncherCmdLog + "'").add("consoleLauncherErrLog='" + this.consoleLauncherErrLog + "'").add("consoleLauncherOutLog='" + this.consoleLauncherOutLog + "'").add("moduleInfoTest='" + this.moduleInfoTest + "'").toString();
    }
}

