/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.maven.plugin;

import de.sormuras.junit.platform.maven.plugin.JUnitPlatformMojo;
import de.sormuras.junit.platform.maven.plugin.Modules;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.module.ModuleDescriptor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.maven.project.MavenProject;

class Patcher {
    private final JUnitPlatformMojo mojo;
    private final MavenProject project;
    private final Modules modules;

    Patcher(JUnitPlatformMojo mojo) {
        this.mojo = mojo;
        this.project = mojo.getMavenProject();
        this.modules = mojo.getProjectModules();
    }

    void patch(List<String> cmd) {
        String testOutput = this.project.getBuild().getTestOutputDirectory();
        ModuleDescriptor descriptor = this.modules.getMainModuleReference().orElseThrow().descriptor();
        String name = descriptor.name();
        this.mojo.debug("", new Object[0]);
        this.mojo.debug("Patching tests into main module %s <- '%s'", name, testOutput);
        cmd.add("--patch-module");
        cmd.add(name + "=" + testOutput);
        String testSource = this.project.getBuild().getTestSourceDirectory();
        Set<Path> roots = Set.of(Paths.get(testSource, new String[0]), Paths.get(testOutput, new String[0]));
        Optional<Path> moduleInfoTest = this.mojo.getFileNames().resolveModuleInfoTest(roots);
        if (moduleInfoTest.isPresent()) {
            Path moduleInfoTestPath = moduleInfoTest.get();
            this.mojo.debug("Using lines of '%s' to patch module %s...", moduleInfoTestPath, name);
            this.appendModuleInfoTestArguments(moduleInfoTestPath, cmd::add);
            return;
        }
        this.mojo.debug("Adding best-effort command line options to patch module %s...", name);
        List<String> addReads = this.createAddReadsModules();
        addReads.forEach(module -> {
            cmd.add("--add-reads");
            cmd.add(name + "=" + module);
        });
        for (String module2 : this.createAddOpensModules()) {
            for (String pack : descriptor.packages()) {
                cmd.add("--add-opens");
                cmd.add(name + "/" + pack + "=" + module2);
            }
        }
    }

    private void appendModuleInfoTestArguments(Path moduleInfoTestPath, Consumer<String> consume) {
        try (Stream<String> lines = Files.lines(moduleInfoTestPath);){
            lines.map(String::trim).filter(line -> !line.isEmpty()).filter(line -> !line.startsWith("//")).peek(line -> this.mojo.debug("  %s", line)).forEach(consume);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Reading " + moduleInfoTestPath + " failed", e);
        }
    }

    private List<String> createAddOpensModules() {
        List<String> value = this.mojo.getJavaOptions().getAddOpens();
        if (value != null) {
            return value;
        }
        ArrayList<String> modules = new ArrayList<String>();
        Map map = this.project.getArtifactMap();
        if (map.containsKey("org.junit.platform:junit-platform-commons")) {
            modules.add("org.junit.platform.commons");
        }
        return modules;
    }

    private List<String> createAddReadsModules() {
        List<String> value = this.mojo.getJavaOptions().getAddReads();
        if (value != null) {
            return value;
        }
        ArrayList<String> modules = new ArrayList<String>();
        Map map = this.project.getArtifactMap();
        if (map.containsKey("org.junit.jupiter:junit-jupiter-api")) {
            modules.add("org.junit.jupiter.api");
        }
        if (map.containsKey("org.junit.jupiter:junit-jupiter-params")) {
            modules.add("org.junit.jupiter.params");
        }
        if (map.containsKey("org.junit.jupiter:junit-jupiter-migrationsupport")) {
            modules.add("org.junit.jupiter.migrationsupport");
        }
        if (map.containsKey("junit:junit")) {
            modules.add("junit");
        }
        return modules;
    }
}

