/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.maven.plugin;

import de.sormuras.junit.platform.maven.plugin.Dependencies;
import de.sormuras.junit.platform.maven.plugin.FileNames;
import de.sormuras.junit.platform.maven.plugin.JavaOptions;
import de.sormuras.junit.platform.maven.plugin.Modules;
import de.sormuras.junit.platform.maven.plugin.Resolver;
import de.sormuras.junit.platform.maven.plugin.Starter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.ContextEnabled;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;

@Component(role=AbstractMavenLifecycleParticipant.class)
@org.apache.maven.plugins.annotations.Mojo(name="launch-junit-platform", defaultPhase=LifecyclePhase.TEST, threadSafe=true, requiresDependencyCollection=ResolutionScope.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class JUnitPlatformMojo
extends AbstractMavenLifecycleParticipant
implements Mojo,
ContextEnabled {
    @Parameter(defaultValue="false")
    private boolean dryRun;
    @Parameter
    private FileNames fileNames = new FileNames();
    @Parameter
    private String javaExecutable;
    @Parameter
    private JavaOptions javaOptions = new JavaOptions();
    @Parameter(defaultValue="${project.build}", readonly=true, required=true)
    private Build mavenBuild;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession mavenRepositorySession;
    @org.apache.maven.plugins.annotations.Component
    private RepositorySystem mavenResolver;
    @Parameter
    private List<String> overrideJavaOptions;
    @Parameter
    private List<String> overrideLauncherOptions;
    @Parameter
    private Map<String, String> parameters = Map.of();
    private Modules projectModules;
    private List<Path> projectPaths;
    private Map<String, String> projectVersions;
    @Parameter(defaultValue="junit-platform/reports")
    private String reports;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter
    private List<String> tags = List.of();
    @Parameter(defaultValue="100")
    private long timeout;
    @Parameter(defaultValue="false")
    private boolean verbose;
    @Parameter
    private Map<String, String> versions = Map.of();
    private Log log;
    private Map pluginContext;

    public void setLog(Log log) {
        this.log = log;
    }

    public Log getLog() {
        if (this.log == null) {
            this.log = new SystemStreamLog();
        }
        return this.log;
    }

    public Map getPluginContext() {
        return this.pluginContext;
    }

    public void setPluginContext(Map pluginContext) {
        this.pluginContext = pluginContext;
    }

    public void afterProjectsRead(MavenSession session) {
        this.debug("Preparing Lifecycle for %s", session);
        for (MavenProject project : session.getProjects()) {
            Optional<Plugin> thisPlugin = this.findPlugin(project, "de.sormuras", "junit-platform-maven-plugin");
            thisPlugin.ifPresent(plugin -> this.injectThisPluginIntoTestExecutionPhase(project, (Plugin)plugin));
        }
    }

    private void injectThisPluginIntoTestExecutionPhase(MavenProject project, Plugin thisPlugin) {
        this.debug("  Inject JUnit Platform Plugin to phase 'test' of project '%s'", project.getName());
        PluginExecution execution = new PluginExecution();
        execution.setId("injected-junit-platform-maven-plugin");
        execution.getGoals().add("launch-junit-platform");
        execution.setPhase("test");
        execution.setConfiguration(thisPlugin.getConfiguration());
        thisPlugin.getExecutions().add(execution);
        this.debug("  Clear Surefire executions", project.getName());
        Optional<Plugin> surefirePlugin = this.findPlugin(project, "org.apache.maven.plugins", "maven-surefire-plugin");
        surefirePlugin.ifPresent(surefire -> surefire.getExecutions().clear());
    }

    private Optional<Plugin> findPlugin(MavenProject project, String group, String artifact) {
        List plugins = project.getModel().getBuild().getPlugins();
        return plugins.stream().filter(plugin -> group.equals(plugin.getGroupId())).filter(plugin -> artifact.equals(plugin.getArtifactId())).reduce((u, v) -> {
            throw new IllegalStateException("Plugin is not unique: " + artifact);
        });
    }

    void debug(String format, Object ... args) {
        this.getLog().debug((CharSequence)String.format(format, args));
    }

    private void dumpParameters() {
        this.debug("", new Object[0]);
        this.debug("Java module system", new Object[0]);
        this.debug("  main -> %s", this.projectModules.toStringMainModule());
        this.debug("  test -> %s", this.projectModules.toStringTestModule());
        this.debug("  mode -> %s", new Object[]{this.projectModules.getMode()});
        this.debug("File names", new Object[0]);
        this.debug("  console-launcher.cmd.log = %s", this.fileNames.getConsoleLauncherCmdLog());
        this.debug("  console-launcher.err.log = %s", this.fileNames.getConsoleLauncherErrLog());
        this.debug("  console-launcher.out.log = %s", this.fileNames.getConsoleLauncherOutLog());
        this.debug("  module-info.test = %s", this.fileNames.getModuleInfoTest());
        this.debug("Versions", new Object[0]);
        this.debug("  java.version = %s (%s)", System.getProperty("java.version"), Runtime.version());
        Dependencies.forEachVersion(v -> this.debug("  %s = %s", v.getKey(), this.version((Dependencies.Version)((Object)v))));
        this.debug("Dependency path (short)", new Object[0]);
        this.projectPaths.forEach(p -> this.debug("  %s", p.getFileName()));
        this.debug("Dependency path (full path)", new Object[0]);
        this.projectPaths.forEach(p -> this.debug("  %s", p));
    }

    public void execute() throws MojoFailureException {
        this.debug("Executing JUnitPlatformMojo...", new Object[0]);
        if (this.skip) {
            this.getLog().info((CharSequence)"JUnit Platform execution skipped.");
            return;
        }
        Path mainPath = Paths.get(this.mavenBuild.getOutputDirectory(), new String[0]);
        Path testPath = Paths.get(this.mavenBuild.getTestOutputDirectory(), new String[0]);
        this.projectModules = new Modules(mainPath, testPath);
        this.projectVersions = Dependencies.createArtifactVersionMap(this::getArtifactVersionOrNull);
        this.projectPaths = new Resolver(this).getPaths();
        this.getLog().info((CharSequence)("Launching JUnit Platform " + this.version(Dependencies.Version.JUNIT_PLATFORM_VERSION) + "..."));
        if (this.getLog().isDebugEnabled()) {
            this.dumpParameters();
        }
        if (Files.notExists(testPath, new LinkOption[0])) {
            this.getLog().info((CharSequence)"Test output directory doesn't exist.");
            return;
        }
        int result = new Starter(this).getAsInt();
        if (result != 0) {
            throw new MojoFailureException("RED ALERT!");
        }
    }

    private String getArtifactVersionOrNull(String key) {
        Artifact artifact = (Artifact)this.mavenProject.getArtifactMap().get(key);
        if (artifact == null) {
            return null;
        }
        return artifact.getBaseVersion();
    }

    FileNames getFileNames() {
        return this.fileNames;
    }

    String getJavaExecutable() {
        if (this.javaExecutable != null) {
            return this.javaExecutable;
        }
        Path path = ProcessHandle.current().info().command().map(x$0 -> Paths.get(x$0, new String[0])).orElseThrow();
        return path.normalize().toAbsolutePath().toString();
    }

    JavaOptions getJavaOptions() {
        return this.javaOptions;
    }

    MavenProject getMavenProject() {
        return this.mavenProject;
    }

    RepositorySystemSession getMavenRepositorySession() {
        return this.mavenRepositorySession;
    }

    RepositorySystem getMavenResolver() {
        return this.mavenResolver;
    }

    Optional<List<String>> getOverrideJavaOptions() {
        return Optional.ofNullable(this.overrideJavaOptions);
    }

    Optional<List<String>> getOverrideLauncherOptions() {
        return Optional.ofNullable(this.overrideLauncherOptions);
    }

    Map<String, String> getParameters() {
        return this.parameters;
    }

    Modules getProjectModules() {
        return this.projectModules;
    }

    List<Path> getProjectPaths() {
        return this.projectPaths;
    }

    Optional<Path> getReportsPath() {
        if (this.reports.trim().isEmpty()) {
            return Optional.empty();
        }
        Path path = Paths.get(this.reports, new String[0]);
        if (path.isAbsolute()) {
            return Optional.of(path);
        }
        return Optional.of(Paths.get(this.mavenBuild.getDirectory(), new String[0]).resolve(path));
    }

    List<String> getTags() {
        return this.tags;
    }

    Duration getTimeout() {
        return Duration.ofSeconds(this.timeout);
    }

    boolean isDryRun() {
        return this.dryRun;
    }

    boolean isVerbose() {
        return this.verbose;
    }

    String version(Dependencies.Version version) {
        String defaultVersion = this.projectVersions.get(version.getKey());
        return this.versions.getOrDefault(version.getKey(), defaultVersion);
    }
}

