/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.maven.plugin;

import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class Modules {
    private final ModuleReference mainModuleReference;
    private final ModuleReference testModuleReference;
    private final Mode mode;

    Modules(Path mainPath, Path testPath) {
        this.mainModuleReference = Modules.getSingleModuleReferenceOrNull(mainPath);
        this.testModuleReference = Modules.getSingleModuleReferenceOrNull(testPath);
        this.mode = Mode.of(Modules.getModuleNameOrNull(this.mainModuleReference), Modules.getModuleNameOrNull(this.testModuleReference));
    }

    Mode getMode() {
        return this.mode;
    }

    Optional<ModuleReference> getMainModuleReference() {
        return Optional.ofNullable(this.mainModuleReference);
    }

    Optional<ModuleReference> getTestModuleReference() {
        return Optional.ofNullable(this.testModuleReference);
    }

    public String toString() {
        return String.format("Modules [main=%s, test=%s]", this.toStringMainModule(), this.toStringTestModule());
    }

    String toStringMainModule() {
        return Modules.toString(this.mainModuleReference);
    }

    String toStringTestModule() {
        return Modules.toString(this.testModuleReference);
    }

    static ModuleReference getSingleModuleReferenceOrNull(Path path) {
        Set<ModuleReference> all = ModuleFinder.of(path).findAll();
        Optional firstOpt = all.stream().findFirst();
        switch (all.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (ModuleReference)firstOpt.get();
            }
        }
        throw new IllegalArgumentException("expected exact one module in " + path + " but found: " + all.stream().map(Object::toString).collect(Collectors.joining(", ", "<", ">")));
    }

    private static String getModuleNameOrNull(ModuleReference reference) {
        if (reference == null) {
            return null;
        }
        return reference.descriptor().name();
    }

    private static String toString(ModuleReference reference) {
        if (reference == null) {
            return "<empty>";
        }
        ModuleDescriptor module = reference.descriptor();
        StringBuilder builder = new StringBuilder();
        if (module.isOpen()) {
            builder.append("open ");
        }
        builder.append("module ").append(module.name());
        builder.append(" {");
        builder.append(" requires=").append(module.requires().stream().map(ModuleDescriptor.Requires::name).collect(Collectors.joining(", ", "[", "]")));
        builder.append(" packages=").append(module.packages());
        builder.append(" }");
        return builder.toString();
    }

    static enum Mode {
        CLASSIC(Barrier.PACKAGE),
        MAIN_CLASSIC_TEST_MODULE(Barrier.MODULE),
        MAIN_MODULE_TEST_CLASSIC(Barrier.PACKAGE),
        MAIN_MODULE_TEST_MODULE_SAME_NAME(Barrier.PACKAGE),
        MODULAR(Barrier.MODULE);

        private final Barrier barrier;

        private Mode(Barrier barrier) {
            this.barrier = barrier;
        }

        public String toString() {
            return this.name() + " [barrier=" + this.barrier + "]";
        }

        static Mode of(String main, String test) {
            if (main == null) {
                if (test == null) {
                    return CLASSIC;
                }
                return MAIN_CLASSIC_TEST_MODULE;
            }
            if (test == null) {
                return MAIN_MODULE_TEST_CLASSIC;
            }
            if (main.equals(test)) {
                return MAIN_MODULE_TEST_MODULE_SAME_NAME;
            }
            return MODULAR;
        }
    }

    static enum Barrier {
        MODULE,
        PACKAGE;

    }
}

