/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.maven.plugin;

import de.sormuras.junit.platform.maven.plugin.JUnitPlatformMojo;
import java.io.File;
import java.io.IOException;
import java.lang.module.ModuleReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.IntSupplier;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

class JUnitPlatformStarter
implements IntSupplier {
    private final JUnitPlatformMojo mojo;
    private final MavenProject project;

    JUnitPlatformStarter(JUnitPlatformMojo mojo) {
        this.mojo = mojo;
        this.project = mojo.getMavenProject();
    }

    private void debug(String format, Object ... args) {
        this.mojo.debug(String.format(format, args), new Object[0]);
    }

    @Override
    public int getAsInt() {
        Log log = this.mojo.getLog();
        Path target = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("junit-platform");
        Path cmdPath = target.resolve("console-launcher.cmd.log");
        Path errorPath = target.resolve("console-launcher.err.log");
        Path outputPath = target.resolve("console-launcher.out.log");
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        List<String> cmd = builder.command();
        builder.redirectError(errorPath.toFile());
        builder.redirectOutput(outputPath.toFile());
        builder.redirectInput(ProcessBuilder.Redirect.INHERIT);
        cmd.add(JUnitPlatformStarter.getCurrentJavaExecutablePath().toString());
        this.mojo.getOverrideJavaOptions().ifPresentOrElse(cmd::addAll, () -> this.addJavaOptions(cmd));
        this.mojo.getOverrideLauncherOptions().ifPresentOrElse(cmd::addAll, () -> this.addLauncherOptions(cmd));
        try {
            Files.createDirectories(target, new FileAttribute[0]);
            Files.write(cmdPath, cmd, new OpenOption[0]);
            if (Files.notExists(errorPath, new LinkOption[0])) {
                Files.createFile(errorPath, new FileAttribute[0]);
            }
            if (Files.notExists(outputPath, new LinkOption[0])) {
                Files.createFile(outputPath, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            log.warn((CharSequence)("Preparing target path failed: " + target), (Throwable)e);
        }
        if (this.mojo.isDryRun()) {
            this.mojo.getLog().info((CharSequence)"Dry-run mode is active -- only printing command line");
            cmd.forEach(arg_0 -> ((Log)this.mojo.getLog()).info(arg_0));
            return 0;
        }
        this.debug("", new Object[0]);
        this.debug("Starting process...", new Object[0]);
        cmd.forEach(x$0 -> this.mojo.debug((String)x$0, new Object[0]));
        try {
            long timeout = this.mojo.getTimeout().toSeconds();
            Process process = builder.start();
            this.debug("Process started: #%d %s", process.pid(), process.info());
            boolean ok = process.waitFor(timeout, TimeUnit.SECONDS);
            if (!ok) {
                String s = timeout == 1L ? "" : "s";
                log.error((CharSequence)("Global timeout of " + timeout + " second" + s + " reached."));
                log.error((CharSequence)("Killing process #" + process.pid()));
                process.destroy();
                return -2;
            }
            int exitValue = process.exitValue();
            Files.readAllLines(outputPath).forEach(exitValue == 0 ? arg_0 -> ((Log)log).info(arg_0) : arg_0 -> ((Log)log).error(arg_0));
            Files.readAllLines(errorPath).forEach(exitValue == 0 ? arg_0 -> ((Log)log).warn(arg_0) : arg_0 -> ((Log)log).error(arg_0));
            return exitValue;
        }
        catch (IOException | InterruptedException e) {
            log.error((CharSequence)"Executing process failed", (Throwable)e);
            return -1;
        }
    }

    private void addJavaOptions(List<String> cmd) {
        String testOutput = this.project.getBuild().getTestOutputDirectory();
        Optional<ModuleReference> mainModule = this.mojo.getModules().getMainModuleReference();
        Optional<ModuleReference> testModule = this.mojo.getModules().getTestModuleReference();
        cmd.addAll(this.mojo.getJavaOptions().getAdditionalOptions());
        if (mainModule.isPresent() || testModule.isPresent()) {
            cmd.add("--module-path");
            cmd.add(this.createPathArgument());
            cmd.add("--add-modules");
            cmd.add(this.createAddModulesArgument());
            if (mainModule.isPresent() && !testModule.isPresent()) {
                String name = mainModule.get().descriptor().name();
                cmd.add("--patch-module");
                cmd.add(name + "=" + testOutput);
                List<String> addReads = this.createAddReadsModules();
                addReads.forEach(module -> {
                    cmd.add("--add-reads");
                    cmd.add(name + "=" + module);
                });
                for (String module2 : this.createAddOpensModules()) {
                    for (String pack : mainModule.get().descriptor().packages()) {
                        cmd.add("--add-opens");
                        cmd.add(name + "/" + pack + "=" + module2);
                    }
                }
            }
            cmd.add("--module");
            cmd.add("org.junit.platform.console");
        } else {
            cmd.add("--class-path");
            cmd.add(this.createPathArgument());
            cmd.add("org.junit.platform.console.ConsoleLauncher");
        }
    }

    private void addLauncherOptions(List<String> cmd) {
        cmd.add("--disable-ansi-colors");
        cmd.add("--details");
        cmd.add("tree");
        this.mojo.getTags().forEach(tag -> cmd.add(this.createTagArgument((String)tag)));
        this.mojo.getParameters().forEach((key, value) -> cmd.add(this.createConfigArgument((String)key, (String)value)));
        this.mojo.getReportsPath().ifPresent(path -> {
            cmd.add("--reports-dir");
            cmd.add(path.toString());
        });
        Optional<ModuleReference> mainModule = this.mojo.getModules().getMainModuleReference();
        Optional<ModuleReference> testModule = this.mojo.getModules().getTestModuleReference();
        if (testModule.isPresent()) {
            cmd.add("--select-module");
            cmd.add(testModule.get().descriptor().name());
        } else if (mainModule.isPresent()) {
            cmd.add("--select-module");
            cmd.add(mainModule.get().descriptor().name());
        } else {
            cmd.add("--scan-class-path");
        }
    }

    private String createAddModulesArgument() {
        String value = this.mojo.getJavaOptions().getAddModules();
        if (value != null) {
            return value;
        }
        switch (this.mojo.getModules().getMode()) {
            case MAIN_MODULE_TEST_CLASSIC: {
                return this.mojo.getModules().getMainModuleReference().orElseThrow().descriptor().name();
            }
        }
        return this.mojo.getModules().getTestModuleReference().orElseThrow().descriptor().name();
    }

    private List<String> createAddOpensModules() {
        List<String> value = this.mojo.getJavaOptions().getAddOpens();
        if (value != null) {
            return value;
        }
        ArrayList<String> modules = new ArrayList<String>();
        Map map = this.project.getArtifactMap();
        if (map.containsKey("org.junit.platform:junit-platform-commons")) {
            modules.add("org.junit.platform.commons");
        }
        return modules;
    }

    private List<String> createAddReadsModules() {
        List<String> value = this.mojo.getJavaOptions().getAddReads();
        if (value != null) {
            return value;
        }
        ArrayList<String> modules = new ArrayList<String>();
        Map map = this.project.getArtifactMap();
        if (map.containsKey("org.junit.jupiter:junit-jupiter-api")) {
            modules.add("org.junit.jupiter.api");
        }
        if (map.containsKey("org.junit.jupiter:junit-jupiter-params")) {
            modules.add("org.junit.jupiter.params");
        }
        if (map.containsKey("org.junit.jupiter:junit-jupiter-migrationsupport")) {
            modules.add("org.junit.jupiter.migrationsupport");
        }
        if (map.containsKey("junit:junit")) {
            modules.add("junit");
        }
        return modules;
    }

    private String createConfigArgument(String key, String value) {
        return "--config=\"" + key + "\"=\"" + value + "\"";
    }

    private String createTagArgument(String tag) {
        return "--include-tag=\"" + tag + "\"";
    }

    private String createPathArgument() {
        this.debug("", new Object[0]);
        this.debug("Creating path argument", new Object[0]);
        ArrayList<String> elements = new ArrayList<String>();
        try {
            String platformConsole;
            for (String element : this.project.getTestClasspathElements()) {
                Path path = Paths.get(element, new String[0]).toAbsolutePath().normalize();
                if (Files.notExists(path, new LinkOption[0])) {
                    this.debug("  X %s // doesn't exist", path);
                    continue;
                }
                this.debug(" -> %s", path);
                elements.add(path.toString());
            }
            Map map = this.project.getArtifactMap();
            Artifact jupiterApi = (Artifact)map.get("org.junit.jupiter:junit-jupiter-api");
            String jupiterEngine = "org.junit.jupiter:junit-jupiter-engine";
            if (jupiterApi != null && !map.containsKey(jupiterEngine)) {
                this.mojo.resolve(elements, jupiterEngine, this.mojo.getJUnitJupiterVersion());
            }
            Artifact vintageApi = (Artifact)map.get("junit:junit");
            String vintageEngine = "org.junit.vintage:junit-vintage-engine";
            if (vintageApi != null && !map.containsKey(vintageEngine) && vintageApi.getVersion().equals("4.12")) {
                this.mojo.resolve(elements, vintageEngine, this.mojo.getJUnitVintageVersion());
            }
            if (!map.containsKey(platformConsole = "org.junit.platform:junit-platform-console")) {
                this.mojo.resolve(elements, platformConsole, this.mojo.getJUnitPlatformVersion());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Resolving test class-path elements failed", e);
        }
        return String.join((CharSequence)File.pathSeparator, elements);
    }

    private static Path getCurrentJavaExecutablePath() {
        Path path = ProcessHandle.current().info().command().map(x$0 -> Paths.get(x$0, new String[0])).orElseThrow();
        return path.normalize().toAbsolutePath();
    }
}

