/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.maven.plugin;

import de.sormuras.junit.platform.maven.plugin.AbstractBaseMojo;
import de.sormuras.junit.platform.maven.plugin.JUnitPlatformStarter;
import de.sormuras.junit.platform.maven.plugin.JavaOptions;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.utils.logging.MessageUtils;

@Mojo(name="launch-junit-platform", defaultPhase=LifecyclePhase.TEST, threadSafe=true, requiresDependencyCollection=ResolutionScope.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class JUnitPlatformMojo
extends AbstractBaseMojo {
    @Parameter(defaultValue="false")
    private boolean dryRun;
    @Parameter
    private JavaOptions javaOptions = new JavaOptions();
    @Parameter
    private List<String> overrideJavaOptions;
    @Parameter
    private List<String> overrideLauncherOptions;
    @Parameter
    private Map<String, String> parameters = Map.of();
    @Parameter(defaultValue="junit-platform/reports")
    private String reports;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter
    private List<String> tags = List.of();
    @Parameter(defaultValue="100")
    private long timeout;
    @Parameter
    private Map<String, String> versions = Map.of();

    public void execute() throws MojoFailureException {
        Log log = this.getLog();
        log.info((CharSequence)"Launching JUnit Platform...");
        if (this.skip) {
            log.info((CharSequence)MessageUtils.buffer().warning((Object)"JUnit Platform execution skipped.").toString());
            return;
        }
        if (Files.notExists(Paths.get(this.getMavenProject().getBuild().getTestOutputDirectory(), new String[0]), new LinkOption[0])) {
            log.info((CharSequence)MessageUtils.buffer().warning((Object)"Test output directory doesn't exist.").toString());
            return;
        }
        this.initialize();
        log.debug((CharSequence)"");
        log.debug((CharSequence)"JUnit-related versions");
        log.debug((CharSequence)("  Platform  -> " + this.getJUnitPlatformVersion()));
        log.debug((CharSequence)("  Jupiter   -> " + this.getJUnitJupiterVersion()));
        log.debug((CharSequence)("  Vintage   -> " + this.getJUnitVintageVersion()));
        log.debug((CharSequence)"Java module system");
        log.debug((CharSequence)("  main -> " + this.getModules().toStringMainModule()));
        log.debug((CharSequence)("  test -> " + this.getModules().toStringTestModule()));
        log.debug((CharSequence)("  mode -> " + this.getModules().getMode()));
        int result = new JUnitPlatformStarter(this).getAsInt();
        if (result != 0) {
            throw new MojoFailureException("RED ALERT!");
        }
    }

    JavaOptions getJavaOptions() {
        return this.javaOptions;
    }

    Optional<List<String>> getOverrideJavaOptions() {
        return Optional.ofNullable(this.overrideJavaOptions);
    }

    Optional<List<String>> getOverrideLauncherOptions() {
        return Optional.ofNullable(this.overrideLauncherOptions);
    }

    Map<String, String> getParameters() {
        return this.parameters;
    }

    String getReports() {
        return this.reports;
    }

    Optional<Path> getReportsPath() {
        String reports = this.getReports();
        if (reports.trim().isEmpty()) {
            return Optional.empty();
        }
        Path path = Paths.get(reports, new String[0]);
        if (path.isAbsolute()) {
            return Optional.of(path);
        }
        return Optional.of(Paths.get(this.getMavenProject().getBuild().getDirectory(), new String[0]).resolve(path));
    }

    List<String> getTags() {
        return this.tags;
    }

    Duration getTimeout() {
        return Duration.ofSeconds(this.timeout);
    }

    String getJUnitJupiterVersion() {
        return this.getVersion("junit.jupiter.version");
    }

    String getJUnitPlatformVersion() {
        return this.getVersion("junit.platform.version");
    }

    String getJUnitVintageVersion() {
        return this.getVersion("junit.vintage.version");
    }

    String getVersion(String key) {
        return this.versions.getOrDefault(key, this.getDetectedVersion(key));
    }

    boolean isDryRun() {
        return this.dryRun;
    }
}

