/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.maven.plugin;

import de.sormuras.junit.platform.maven.plugin.Modules;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;

abstract class AbstractBaseMojo
extends AbstractMojo {
    private Map<String, String> detectedVersions;
    private Modules modules;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.remotePluginRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repositories;
    @Component
    private RepositorySystem resolver;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession session;

    AbstractBaseMojo() {
    }

    void debug(String format, Object ... args) {
        this.getLog().debug((CharSequence)String.format(format, args));
    }

    String getDetectedVersion(String key) {
        return this.detectedVersions.get(key);
    }

    MavenProject getMavenProject() {
        return this.project;
    }

    Modules getModules() {
        return this.modules;
    }

    void initialize() {
        this.modules = this.initializeModules(this.getMavenProject().getBuild());
        this.detectedVersions = this.initializeDetectedVersions(this.getMavenProject());
    }

    private Modules initializeModules(Build build) {
        Path mainPath = Paths.get(build.getOutputDirectory(), new String[0]);
        Path testPath = Paths.get(build.getTestOutputDirectory(), new String[0]);
        return new Modules(mainPath, testPath);
    }

    private Map<String, String> initializeDetectedVersions(MavenProject project) {
        org.apache.maven.artifact.Artifact jupiterApi;
        Map map = project.getArtifactMap();
        org.apache.maven.artifact.Artifact jupiterEngine = (org.apache.maven.artifact.Artifact)map.get("org.junit.jupiter:junit-jupiter-engine");
        String jupiterVersion = jupiterEngine != null ? jupiterEngine.getVersion() : ((jupiterApi = (org.apache.maven.artifact.Artifact)map.get("org.junit.jupiter:junit-jupiter-api")) != null ? jupiterApi.getVersion() : "5.3.0-RC1");
        org.apache.maven.artifact.Artifact vintageEngine = (org.apache.maven.artifact.Artifact)map.get("org.junit.vintage:junit-vintage-engine");
        String vintageVersion = vintageEngine != null ? vintageEngine.getVersion() : "5.3.0-RC1";
        org.apache.maven.artifact.Artifact platformCommons = (org.apache.maven.artifact.Artifact)map.get("org.junit.platform:junit-platform-commons");
        String platformVersion = platformCommons != null ? platformCommons.getVersion() : "1.3.0-RC1";
        return Map.of("junit.jupiter.version", jupiterVersion, "junit.vintage.version", vintageVersion, "junit.platform.version", platformVersion);
    }

    void resolve(List<String> elements, String groupAndArtifact, String version) throws Exception {
        Map map = this.project.getArtifactMap();
        if (map.containsKey(groupAndArtifact)) {
            this.debug("Skip resolving '%s', because it is already mapped.", groupAndArtifact);
            return;
        }
        String gav = groupAndArtifact + ":" + version;
        this.debug("", new Object[0]);
        this.debug("Resolving '%s' and its transitive dependencies...", gav);
        for (Artifact resolved : this.resolve(gav)) {
            Path path;
            String element;
            String key = resolved.getGroupId() + ":" + resolved.getArtifactId();
            if (map.containsKey(key) || elements.contains(element = (path = resolved.getFile().toPath().toAbsolutePath().normalize()).toString())) continue;
            this.debug(" -> %s", element);
            elements.add(element);
        }
    }

    private List<Artifact> resolve(String coordinates) throws Exception {
        DefaultArtifact artifact = new DefaultArtifact(coordinates);
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact((Artifact)artifact);
        artifactRequest.setRepositories(this.repositories);
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency((Artifact)artifact, ""));
        collectRequest.setRepositories(this.repositories);
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, (all, ways) -> true);
        List artifacts = this.resolver.resolveDependencies(this.session, dependencyRequest).getArtifactResults();
        return artifacts.stream().map(ArtifactResult::getArtifact).collect(Collectors.toList());
    }
}

