/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.maven.plugin;

import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class Modules {
    private final Path mainPath;
    private final Path testPath;

    Modules(Path mainPath, Path testPath) {
        this.mainPath = mainPath;
        this.testPath = testPath;
    }

    Path getMainPath() {
        return this.mainPath;
    }

    Path getTestPath() {
        return this.testPath;
    }

    Optional<ModuleReference> getMainModuleReference() {
        return Optional.ofNullable(Modules.getSingleModuleReferenceOrNull(this.getMainPath()));
    }

    Optional<ModuleReference> getTestModuleReference() {
        return Optional.ofNullable(Modules.getSingleModuleReferenceOrNull(this.getTestPath()));
    }

    static ModuleReference getSingleModuleReferenceOrNull(Path path) {
        Set<ModuleReference> all = ModuleFinder.of(path).findAll();
        Optional firstOpt = all.stream().findFirst();
        switch (all.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (ModuleReference)firstOpt.get();
            }
        }
        throw new IllegalArgumentException("expected exact one module in " + path + " but found: " + all.stream().map(Object::toString).collect(Collectors.joining(", ", "<", ">")));
    }
}

