/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.maven.plugin;

import de.sormuras.junit.platform.maven.plugin.JUnitPlatformMojo;
import de.sormuras.junit.platform.maven.plugin.Modules;
import java.io.File;
import java.io.IOException;
import java.lang.module.ModuleReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.IntSupplier;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;

class JUnitPlatformStarter
implements IntSupplier {
    private final JUnitPlatformMojo mojo;
    private final Modules modules;

    JUnitPlatformStarter(JUnitPlatformMojo mojo, Modules modules) {
        this.mojo = mojo;
        this.modules = modules;
    }

    private void debug(String format, Object ... args) {
        this.mojo.debug(String.format(format, args), new Object[0]);
    }

    @Override
    public int getAsInt() {
        Log log = this.mojo.getLog();
        Build build = this.mojo.getMavenProject().getBuild();
        Path target = Paths.get(build.getDirectory(), new String[0]);
        String testClasses = build.getTestOutputDirectory();
        Optional<Path> reports = this.mojo.getReportsPath();
        Optional<ModuleReference> mainModule = this.modules.getMainModuleReference();
        Optional<ModuleReference> testModule = this.modules.getTestModuleReference();
        Path errorPath = target.resolve("junit-platform-console-launcher.err.txt");
        Path outputPath = target.resolve("junit-platform-console-launcher.out.txt");
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        List<String> cmd = builder.command();
        builder.redirectError(errorPath.toFile());
        builder.redirectOutput(outputPath.toFile());
        builder.redirectInput(ProcessBuilder.Redirect.INHERIT);
        cmd.add(JUnitPlatformStarter.getCurrentJavaExecutablePath().toString());
        if (testModule.isPresent()) {
            cmd.add("--module-path");
            cmd.add(this.createPathArgument());
            cmd.add("--add-modules");
            cmd.add("ALL-MODULE-PATH,ALL-DEFAULT");
            cmd.add("--module");
            cmd.add("org.junit.platform.console");
        } else if (mainModule.isPresent()) {
            cmd.add("--module-path");
            cmd.add(this.createPathArgument());
            cmd.add("--add-modules");
            cmd.add("ALL-MODULE-PATH,ALL-DEFAULT");
            String name = mainModule.get().descriptor().name();
            cmd.add("--patch-module");
            cmd.add(name + "=" + testClasses);
            cmd.add("--add-reads");
            cmd.add(name + "=org.junit.jupiter.api");
            Set<String> packages = mainModule.get().descriptor().packages();
            packages.forEach(pkg -> {
                cmd.add("--add-opens");
                cmd.add(name + "/" + pkg + "=org.junit.platform.commons");
            });
            cmd.add("--module");
            cmd.add("org.junit.platform.console");
        } else {
            cmd.add("--class-path");
            cmd.add(this.createPathArgument());
            cmd.add("org.junit.platform.console.ConsoleLauncher");
        }
        cmd.add("--disable-ansi-colors");
        cmd.add("--details");
        cmd.add("tree");
        this.mojo.getTags().forEach(tag -> cmd.add(this.createTagArgument((String)tag)));
        this.mojo.getParameters().forEach((key, value) -> cmd.add(this.createConfigArgument((String)key, (String)value)));
        reports.ifPresent(path -> {
            cmd.add("--reports-dir");
            cmd.add(path.toString());
        });
        if (testModule.isPresent()) {
            cmd.add("--select-module");
            cmd.add(testModule.get().descriptor().name());
        } else if (mainModule.isPresent()) {
            cmd.add("--select-module");
            cmd.add(mainModule.get().descriptor().name());
        } else {
            cmd.add("--scan-class-path");
        }
        this.debug("", new Object[0]);
        this.debug("Starting process...", new Object[0]);
        cmd.forEach(x$0 -> this.mojo.debug((String)x$0, new Object[0]));
        try {
            long timeout = this.mojo.getTimeout().toSeconds();
            Process process = builder.start();
            this.debug("Process started: #%d %s", process.pid(), process.info());
            boolean ok = process.waitFor(timeout, TimeUnit.SECONDS);
            if (!ok) {
                String s = timeout == 1L ? "" : "s";
                log.error((CharSequence)("Global timeout of " + timeout + " second" + s + " reached."));
                log.error((CharSequence)("Killing process #" + process.pid()));
                process.destroy();
                return -2;
            }
            int exitValue = process.exitValue();
            Files.readAllLines(outputPath).forEach(exitValue == 0 ? arg_0 -> ((Log)log).info(arg_0) : arg_0 -> ((Log)log).error(arg_0));
            Files.readAllLines(errorPath).forEach(exitValue == 0 ? arg_0 -> ((Log)log).warn(arg_0) : arg_0 -> ((Log)log).error(arg_0));
            return exitValue;
        }
        catch (IOException | InterruptedException e) {
            log.error((CharSequence)"Executing process failed", (Throwable)e);
            return -1;
        }
    }

    private String createConfigArgument(String key, String value) {
        return "--config=\"" + key + "\"=\"" + value + "\"";
    }

    private String createTagArgument(String tag) {
        return "--include-tag=\"" + tag + "\"";
    }

    private String createPathArgument() {
        MavenProject project = this.mojo.getMavenProject();
        ArrayList<String> elements = new ArrayList<String>();
        try {
            for (String element : project.getTestClasspathElements()) {
                Path path = Paths.get(element, new String[0]).toAbsolutePath().normalize();
                if (Files.notExists(path, new LinkOption[0])) {
                    this.debug("  X %s // doesn't exist", path);
                    continue;
                }
                this.debug(" -> %s", path);
                elements.add(path.toString());
            }
            Map map = project.getArtifactMap();
            org.apache.maven.artifact.Artifact jupiterApi = (org.apache.maven.artifact.Artifact)map.get("org.junit.jupiter:junit-jupiter-api");
            String jupiterEngine = "org.junit.jupiter:junit-jupiter-engine";
            String jupiterVersion = this.mojo.getJUnitJupiterVersion();
            if (jupiterApi != null && !map.containsKey(jupiterEngine)) {
                jupiterVersion = jupiterApi.getVersion();
                this.resolve(elements, jupiterEngine, jupiterVersion);
            }
            org.apache.maven.artifact.Artifact vintageApi = (org.apache.maven.artifact.Artifact)map.get("junit:junit");
            String vintageEngine = "org.junit.vintage:junit-vintage-engine";
            if (vintageApi != null && !map.containsKey(vintageEngine)) {
                try {
                    this.resolve(elements, vintageEngine, this.mojo.getJUnitVintageVersion());
                }
                catch (Exception e) {
                    this.resolve(elements, vintageEngine, jupiterVersion);
                }
            }
            String platformConsole = "org.junit.platform:junit-platform-console";
            String platformVersion = "1" + jupiterVersion.substring(1);
            try {
                this.resolve(elements, platformConsole, platformVersion);
            }
            catch (Exception e) {
                this.resolve(elements, platformConsole, this.mojo.getJUnitPlatformVersion());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Resolving test class-path elements failed", e);
        }
        return String.join((CharSequence)File.pathSeparator, elements);
    }

    private void resolve(List<String> elements, String groupAndArtifact, String version) throws Exception {
        Map map = this.mojo.getMavenProject().getArtifactMap();
        if (map.containsKey(groupAndArtifact)) {
            this.debug("Skip resolving '%s', because it is already mapped.", groupAndArtifact);
            return;
        }
        String gav = groupAndArtifact + ":" + version;
        this.debug("", new Object[0]);
        this.debug("Resolving '%s' and its transitive dependencies...", gav);
        for (Artifact resolved : this.mojo.resolve(gav)) {
            String key = resolved.getGroupId() + ":" + resolved.getArtifactId();
            if (map.containsKey(key)) {
                this.debug("  X %s // mapped by project", resolved);
                continue;
            }
            Path path = resolved.getFile().toPath().toAbsolutePath().normalize();
            String element = path.toString();
            if (elements.contains(element)) {
                this.debug("  X %s // already added", resolved);
                continue;
            }
            this.debug(" -> %s", element);
            elements.add(element);
        }
    }

    private static Path getCurrentJavaExecutablePath() {
        Path path = ProcessHandle.current().info().command().map(x$0 -> Paths.get(x$0, new String[0])).orElseThrow();
        return path.normalize().toAbsolutePath();
    }
}

