/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.maven.plugin;

import de.sormuras.junit.platform.maven.plugin.AbstractBaseMojo;
import de.sormuras.junit.platform.maven.plugin.JUnitPlatformStarter;
import de.sormuras.junit.platform.maven.plugin.Modules;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.utils.logging.MessageUtils;

@Mojo(name="launch-junit-platform", defaultPhase=LifecyclePhase.TEST, threadSafe=true, requiresDependencyCollection=ResolutionScope.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class JUnitPlatformMojo
extends AbstractBaseMojo {
    @Parameter
    private Map<String, String> parameters = Map.of();
    @Parameter(defaultValue="junit-platform-reports")
    private String reports;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter
    private List<String> tags = List.of();
    @Parameter(defaultValue="100")
    private long timeout;
    @Parameter
    private Map<String, String> versions = Map.of();

    public void execute() throws MojoFailureException {
        Log log = this.getLog();
        log.info((CharSequence)"Launching JUnit Platform...");
        if (this.skip) {
            log.info((CharSequence)MessageUtils.buffer().warning((Object)"JUnit Platform execution skipped.").toString());
            return;
        }
        Build build = this.getMavenProject().getBuild();
        Path mainPath = Paths.get(build.getOutputDirectory(), new String[0]);
        Path testPath = Paths.get(build.getTestOutputDirectory(), new String[0]);
        Modules modules = new Modules(mainPath, testPath);
        log.debug((CharSequence)"");
        log.debug((CharSequence)("Main module reference -> " + modules.getMainModuleReference()));
        log.debug((CharSequence)("Test module reference -> " + modules.getTestModuleReference()));
        int result = new JUnitPlatformStarter(this, modules).getAsInt();
        if (result != 0) {
            throw new MojoFailureException("RED ALERT!");
        }
    }

    Map<String, String> getParameters() {
        return this.parameters;
    }

    String getReports() {
        return this.reports;
    }

    Optional<Path> getReportsPath() {
        String reports = this.getReports();
        if (reports.trim().isEmpty()) {
            return Optional.empty();
        }
        Path path = Paths.get(reports, new String[0]);
        if (path.isAbsolute()) {
            return Optional.of(path);
        }
        return Optional.of(Paths.get(this.getMavenProject().getBuild().getDirectory(), new String[0]).resolve(path));
    }

    List<String> getTags() {
        return this.tags;
    }

    Duration getTimeout() {
        return Duration.ofSeconds(this.timeout);
    }

    String getJUnitJupiterVersion() {
        return this.versions.getOrDefault("junit.jupiter.version", "5.3.0-RC1");
    }

    String getJUnitPlatformVersion() {
        return this.versions.getOrDefault("junit.platform.version", "1.3.0-RC1");
    }

    String getJUnitVintageVersion() {
        return this.versions.getOrDefault("junit.vintage.version", "5.3.0-RC1");
    }
}

