/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.maven.plugin;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;

abstract class AbstractBaseMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component
    private RepositorySystem resolver;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession session;
    @Parameter(defaultValue="${project.remotePluginRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repositories;

    AbstractBaseMojo() {
    }

    void debug(String format, Object ... args) {
        this.getLog().debug((CharSequence)String.format(format, args));
    }

    MavenProject getMavenProject() {
        return this.project;
    }

    List<Artifact> resolve(String coordinates) throws Exception {
        DefaultArtifact artifact = new DefaultArtifact(coordinates);
        this.debug("Resolving artifact %s from %s...", artifact, this.repositories);
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact((Artifact)artifact);
        artifactRequest.setRepositories(this.repositories);
        ArtifactResult resolved = this.resolver.resolveArtifact(this.session, artifactRequest);
        this.debug("Resolved %s from %s", artifact, resolved.getRepository());
        this.debug("Stored %s to %s", artifact, resolved.getArtifact().getFile());
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency((Artifact)artifact, ""));
        collectRequest.setRepositories(this.repositories);
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, (all, ways) -> true);
        this.debug("Resolving dependencies %s...", dependencyRequest);
        List artifacts = this.resolver.resolveDependencies(this.session, dependencyRequest).getArtifactResults();
        return artifacts.stream().map(ArtifactResult::getArtifact).peek(a -> this.debug("Artifact %s resolved to %s", a, a.getFile())).collect(Collectors.toList());
    }
}

