/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.maven.plugin;

import de.sormuras.junit.platform.maven.plugin.Configuration;
import de.sormuras.junit.platform.maven.plugin.JUnitPlatformCaller;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.logging.MessageUtils;

@Mojo(name="launch-junit-platform", defaultPhase=LifecyclePhase.TEST, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class JUnitPlatformMavenPluginMojo
extends AbstractMojo
implements Configuration {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="100")
    private long timeout;
    @Parameter
    private Map<String, String> parameters = new HashMap<String, String>();
    @Parameter(defaultValue="true")
    private boolean strict;
    @Parameter(defaultValue="junit-platform-reports")
    private String reports;
    @Parameter(readonly=true)
    private List<String> tags = new ArrayList<String>();

    @Override
    public MavenProject getMavenProject() {
        return this.project;
    }

    @Override
    public Duration getTimeout() {
        return Duration.ofSeconds(this.timeout);
    }

    @Override
    public boolean isStrict() {
        return this.strict;
    }

    @Override
    public String getReports() {
        return this.reports;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        log.debug((CharSequence)("Executing " + this.getClass().getTypeName() + "..."));
        log.debug((CharSequence)"");
        if (this.skip) {
            log.info((CharSequence)MessageUtils.buffer().warning((Object)"JUnit Platform skipped.").toString());
            return;
        }
        ClassLoader loader = this.createClassLoader();
        Class<?> callerClass = JUnitPlatformMavenPluginMojo.load(loader, JUnitPlatformCaller.class);
        Class[] callerTypes = new Class[]{ClassLoader.class, Configuration.class};
        IntSupplier caller = (IntSupplier)JUnitPlatformMavenPluginMojo.create(callerClass, callerTypes, loader, this);
        int result = caller.getAsInt();
        if (result != 0) {
            throw new MojoFailureException("RED ALERT!");
        }
    }

    private ClassLoader createClassLoader() throws MojoExecutionException {
        URL[] urls;
        Log log = this.getLog();
        log.debug((CharSequence)"  Creating classloader using the following elements:");
        ClassLoader parent = this.getClass().getClassLoader();
        try {
            List elements = this.project.getTestClasspathElements();
            urls = new URL[this.project.getTestClasspathElements().size()];
            for (int i = 0; i < elements.size(); ++i) {
                urls[i] = Paths.get((String)elements.get(i), new String[0]).toAbsolutePath().normalize().toUri().toURL();
                log.debug((CharSequence)("  -> " + urls[i]));
            }
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Resolving test class-path elements failed", (Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Malformed URL in test class-path detected: ", (Exception)e);
        }
        log.debug((CharSequence)"");
        return URLClassLoader.newInstance(urls, parent);
    }

    private static Class<?> load(ClassLoader loader, Class<?> type) {
        String name = type.getName();
        try {
            return loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Object create(Class<?> type, Class<?>[] parameterTypes, Object ... args) {
        try {
            return type.getConstructor(parameterTypes).newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw JUnitPlatformMavenPluginMojo.rethrow(e.getCause());
        }
    }

    private static UndeclaredThrowableException rethrow(Throwable cause) {
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        return new UndeclaredThrowableException(cause);
    }
}

